/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;

public class ErrorImpl
implements Error {
    private final int code;
    private final String state;
    private final String message;
    private boolean handled;

    @Override
    public void setHandled(boolean handled, Configuration configuration) {
        if (!LicenseGuard.isLicensed(configuration, Tier.PREMIUM)) {
            throw new FlywayTeamsUpgradeRequiredException("Error handling");
        }
        this.handled = handled;
    }

    public ErrorImpl(int code, String state, String message) {
        this.code = code;
        this.state = state;
        this.message = message;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean isHandled() {
        return this.handled;
    }
}

