/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import java.util.Objects;
import java.util.function.Function;

public class SwitchModule<T>
extends AbstractConfigurationAwareModule {
    private final Class<T> config;
    private final Function<T, Module> moduleProvider;

    public static <C, V> Module switchModule(Class<C> config, Function<C, V> valueProvider, Function<V, Module> moduleProvider) {
        Objects.requireNonNull(valueProvider, "valueProvider is null");
        moduleProvider = Objects.requireNonNull(moduleProvider, "moduleProvider is null");
        return new SwitchModule<C>(config, valueProvider.andThen(moduleProvider));
    }

    private SwitchModule(Class<T> config, Function<T, Module> moduleProvider) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.moduleProvider = Objects.requireNonNull(moduleProvider, "moduleProvider is null");
    }

    @Override
    protected void setup(Binder binder) {
        T configuration = this.buildConfigObject(this.config);
        this.install(this.moduleProvider.apply(configuration));
    }
}

