/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.session;

import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.function.Consumer;

public final class PropertyMetadataUtil {
    private PropertyMetadataUtil() {
    }

    public static PropertyMetadata<DataSize> dataSizeProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return PropertyMetadataUtil.dataSizeProperty(name, description, defaultValue, value -> {}, hidden);
    }

    public static PropertyMetadata<DataSize> dataSizeProperty(String name, String description, DataSize defaultValue, Consumer<DataSize> validation, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.VARCHAR, DataSize.class, (Object)defaultValue, hidden, object -> {
            DataSize value = DataSize.valueOf((String)((String)object));
            validation.accept(value);
            return value;
        }, DataSize::toString);
    }

    public static void validateMinDataSize(String name, DataSize value, DataSize min) {
        if (value.compareTo(min) < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "%s must be at least %s: %s".formatted(name, min, value));
        }
    }

    public static void validateMaxDataSize(String name, DataSize value, DataSize max) {
        if (value.compareTo(max) > 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "%s must be at most %s: %s".formatted(name, max, value));
        }
    }

    public static PropertyMetadata<Duration> durationProperty(String name, String description, Duration defaultValue, boolean hidden) {
        return PropertyMetadataUtil.durationProperty(name, description, defaultValue, value -> {}, hidden);
    }

    public static PropertyMetadata<Duration> durationProperty(String name, String description, Duration defaultValue, Consumer<Duration> validation, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.VARCHAR, Duration.class, (Object)defaultValue, hidden, object -> {
            Duration value = Duration.valueOf((String)((String)object));
            validation.accept(value);
            return value;
        }, Duration::toString);
    }
}

