/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.io;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;

public final class ByteBuffers {
    private ByteBuffers() {
    }

    public static byte[] getWrappedBytes(ByteBuffer byteBuffer) {
        Preconditions.checkArgument((boolean)byteBuffer.hasArray(), (Object)"buffer does not have array");
        Preconditions.checkArgument((byteBuffer.arrayOffset() == 0 ? 1 : 0) != 0, (String)"buffer has non-zero array offset: %s", (int)byteBuffer.arrayOffset());
        Preconditions.checkArgument((byteBuffer.position() == 0 ? 1 : 0) != 0, (String)"buffer has been repositioned to %s", (int)byteBuffer.position());
        byte[] array = byteBuffer.array();
        Preconditions.checkArgument((byteBuffer.remaining() == array.length ? 1 : 0) != 0, (String)"buffer has %s remaining bytes while array length is %s", (int)byteBuffer.remaining(), (int)array.length);
        return array;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0 && byteBuffer.position() == 0) {
            byte[] array = byteBuffer.array();
            if (byteBuffer.remaining() == array.length) {
                return array;
            }
        }
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.asReadOnlyBuffer().get(bytes);
        return bytes;
    }
}

