/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.plugin.base.security.BaseFileBasedConnectorAccessControlTest;
import io.trino.plugin.base.util.TestingHttpServer;
import io.trino.spi.connector.ConnectorAccessControl;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class TestHttpFileBasedAccessControl
extends BaseFileBasedConnectorAccessControlTest {
    private TestingHttpServer testingHttpServer;

    @BeforeClass
    public void setUp() {
        this.testingHttpServer = new TestingHttpServer();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws IOException {
        Closeables.closeAll((Closeable[])new Closeable[]{this.testingHttpServer});
    }

    @Override
    protected ConnectorAccessControl createAccessControl(File configFile, Map<String, String> properties) {
        try {
            String dataUrl = this.testingHttpServer.resource(configFile.getCanonicalFile().getAbsolutePath()).toString();
            return this.createAccessControl((Map<String, String>)ImmutableMap.builder().putAll(properties).put((Object)"security.config-file", (Object)dataUrl).buildOrThrow());
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating SystemAccessControl", e);
        }
    }
}

