/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.security.FileBasedAccessControl;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.testing.InterfaceTestUtils;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Files;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseFileBasedConnectorAccessControlTest {
    private static final ConnectorSecurityContext ADMIN = BaseFileBasedConnectorAccessControlTest.user("admin", (Set<String>)ImmutableSet.of((Object)"admin", (Object)"staff"));
    private static final ConnectorSecurityContext ALICE = BaseFileBasedConnectorAccessControlTest.user("alice", (Set<String>)ImmutableSet.of((Object)"staff"));
    private static final ConnectorSecurityContext BOB = BaseFileBasedConnectorAccessControlTest.user("bob", (Set<String>)ImmutableSet.of((Object)"staff"));
    private static final ConnectorSecurityContext CHARLIE = BaseFileBasedConnectorAccessControlTest.user("charlie", (Set<String>)ImmutableSet.of((Object)"guests"));
    private static final ConnectorSecurityContext JOE = BaseFileBasedConnectorAccessControlTest.user("joe", (Set<String>)ImmutableSet.of());
    private static final ConnectorSecurityContext UNKNOWN = BaseFileBasedConnectorAccessControlTest.user("unknown", (Set<String>)ImmutableSet.of());

    protected abstract ConnectorAccessControl createAccessControl(File var1, Map<String, String> var2);

    @Test
    public void testEmptyFile() {
        ConnectorAccessControl accessControl = this.createAccessControl("empty.json");
        accessControl.checkCanCreateSchema(UNKNOWN, "unknown", (Map)ImmutableMap.of());
        accessControl.checkCanDropSchema(UNKNOWN, "unknown");
        accessControl.checkCanRenameSchema(UNKNOWN, "unknown", "new_unknown");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(UNKNOWN, "unknown", new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        accessControl.checkCanShowCreateSchema(UNKNOWN, "unknown");
        accessControl.checkCanSelectFromColumns(UNKNOWN, new SchemaTableName("unknown", "unknown"), (Set)ImmutableSet.of());
        accessControl.checkCanShowColumns(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanInsertIntoTable(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanDeleteFromTable(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanCreateTable(UNKNOWN, new SchemaTableName("unknown", "unknown"), Map.of());
        accessControl.checkCanDropTable(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanTruncateTable(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanRenameTable(UNKNOWN, new SchemaTableName("unknown", "unknown"), new SchemaTableName("unknown", "new_unknown"));
        accessControl.checkCanAlterColumn(UNKNOWN, new SchemaTableName("unknown", "unknown"));
        accessControl.checkCanSetCatalogSessionProperty(UNKNOWN, "anything");
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assert.assertEquals((Set)accessControl.filterTables(UNKNOWN, (Set)tables), (Set)tables);
        TrinoPrincipal someUser = new TrinoPrincipal(PrincipalType.USER, "some_user");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantTablePrivilege(ADMIN, Privilege.SELECT, new SchemaTableName("any", "any"), someUser, false));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenyTablePrivilege(ADMIN, Privilege.SELECT, new SchemaTableName("any", "any"), someUser));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeTablePrivilege(ADMIN, Privilege.SELECT, new SchemaTableName("any", "any"), someUser, false));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateRole(ADMIN, "role", Optional.empty()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropRole(ADMIN, "role"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantRoles(ADMIN, (Set)ImmutableSet.of((Object)"test"), (Set)ImmutableSet.of((Object)someUser), false, Optional.empty()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeRoles(ADMIN, (Set)ImmutableSet.of((Object)"test"), (Set)ImmutableSet.of((Object)someUser), false, Optional.empty()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetRole(ADMIN, "role"));
        accessControl.checkCanShowRoles(UNKNOWN);
        accessControl.checkCanShowCurrentRoles(UNKNOWN);
        accessControl.checkCanShowRoleGrants(UNKNOWN);
    }

    @Test
    public void testEmptyFunctionKind() {
        Assertions.assertThatThrownBy(() -> this.createAccessControl("empty-functions-kind.json")).hasRootCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("functionKinds cannot be empty, provide at least one function kind [SCALAR, AGGREGATE, WINDOW, TABLE]");
    }

    @Test
    public void testDisallowFunctionKindRuleCombination() {
        Assertions.assertThatThrownBy(() -> this.createAccessControl("disallow-function-rule-combination.json")).hasRootCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("Cannot define schema for others function kinds than TABLE");
        Assertions.assertThatThrownBy(() -> this.createAccessControl("disallow-function-rule-combination-without-table.json")).hasRootCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("Cannot define schema for others function kinds than TABLE");
    }

    @Test
    public void testSchemaRules() {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        ImmutableMap properties = ImmutableMap.of();
        accessControl.checkCanCreateSchema(ADMIN, "bob", (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, "staff", (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, "authenticated", (Map)properties);
        accessControl.checkCanCreateSchema(ADMIN, "test", (Map)properties);
        accessControl.checkCanCreateSchema(BOB, "bob", (Map)properties);
        accessControl.checkCanCreateSchema(BOB, "staff", (Map)properties);
        accessControl.checkCanCreateSchema(BOB, "authenticated", (Map)properties);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> BaseFileBasedConnectorAccessControlTest.lambda$testSchemaRules$12(accessControl, (Map)properties));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> BaseFileBasedConnectorAccessControlTest.lambda$testSchemaRules$13(accessControl, (Map)properties));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> BaseFileBasedConnectorAccessControlTest.lambda$testSchemaRules$14(accessControl, (Map)properties));
        accessControl.checkCanCreateSchema(CHARLIE, "authenticated", (Map)properties);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> BaseFileBasedConnectorAccessControlTest.lambda$testSchemaRules$15(accessControl, (Map)properties));
        accessControl.checkCanDropSchema(ADMIN, "bob");
        accessControl.checkCanDropSchema(ADMIN, "staff");
        accessControl.checkCanDropSchema(ADMIN, "authenticated");
        accessControl.checkCanDropSchema(ADMIN, "test");
        accessControl.checkCanDropSchema(BOB, "bob");
        accessControl.checkCanDropSchema(BOB, "staff");
        accessControl.checkCanDropSchema(BOB, "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropSchema(BOB, "test"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropSchema(CHARLIE, "bob"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropSchema(CHARLIE, "staff"));
        accessControl.checkCanDropSchema(CHARLIE, "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropSchema(CHARLIE, "test"));
        accessControl.checkCanRenameSchema(ADMIN, "bob", "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, "staff", "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, "authenticated", "new_schema");
        accessControl.checkCanRenameSchema(ADMIN, "test", "new_schema");
        accessControl.checkCanRenameSchema(BOB, "bob", "staff");
        accessControl.checkCanRenameSchema(BOB, "staff", "authenticated");
        accessControl.checkCanRenameSchema(BOB, "authenticated", "bob");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(BOB, "test", "bob"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(BOB, "bob", "test"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, "bob", "new_schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, "staff", "new_schema"));
        accessControl.checkCanRenameSchema(CHARLIE, "authenticated", "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameSchema(CHARLIE, "test", "new_schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(ADMIN, "test", new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(ADMIN, "test", new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BOB, "bob", new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BOB, "bob", new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BOB, "test", new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BOB, "test", new TrinoPrincipal(PrincipalType.USER, "some_user")));
        accessControl.checkCanShowCreateSchema(ADMIN, "bob");
        accessControl.checkCanShowCreateSchema(ADMIN, "staff");
        accessControl.checkCanShowCreateSchema(ADMIN, "authenticated");
        accessControl.checkCanShowCreateSchema(ADMIN, "test");
        accessControl.checkCanShowCreateSchema(BOB, "bob");
        accessControl.checkCanShowCreateSchema(BOB, "staff");
        accessControl.checkCanShowCreateSchema(BOB, "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowCreateSchema(BOB, "test"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, "bob"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, "staff"));
        accessControl.checkCanShowCreateSchema(CHARLIE, "authenticated");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowCreateSchema(CHARLIE, "test"));
    }

    @Test(dataProvider="privilegeGrantOption")
    public void testGrantSchemaPrivilege(Privilege privilege, boolean grantOption) {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, "bob", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, "staff", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, "authenticated", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(ADMIN, privilege, "test", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, "bob", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, "staff", grantee, grantOption);
        accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, "authenticated", grantee, grantOption);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantSchemaPrivilege(BOB, privilege, "test", grantee, grantOption));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, "bob", grantee, grantOption));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, "staff", grantee, grantOption));
        accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, "authenticated", grantee, grantOption);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantSchemaPrivilege(CHARLIE, privilege, "test", grantee, grantOption));
    }

    @Test
    public void testDenySchemaPrivilege() {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, "bob", grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, "staff", grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, "authenticated", grantee);
        accessControl.checkCanDenySchemaPrivilege(ADMIN, Privilege.UPDATE, "test", grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, "bob", grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, "staff", grantee);
        accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, "authenticated", grantee);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenySchemaPrivilege(BOB, Privilege.UPDATE, "test", grantee));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, "bob", grantee));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, "staff", grantee));
        accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, "authenticated", grantee);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDenySchemaPrivilege(CHARLIE, Privilege.UPDATE, "test", grantee));
    }

    @Test(dataProvider="privilegeGrantOption")
    public void testRevokeSchemaPrivilege(Privilege privilege, boolean grantOption) {
        ConnectorAccessControl accessControl = this.createAccessControl("schema.json");
        TrinoPrincipal grantee = new TrinoPrincipal(PrincipalType.USER, "alice");
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, "bob", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, "staff", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, "authenticated", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(ADMIN, privilege, "test", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, "bob", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, "staff", grantee, grantOption);
        accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, "authenticated", grantee, grantOption);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(BOB, privilege, "test", grantee, grantOption));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, "bob", grantee, grantOption));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, "staff", grantee, grantOption));
        accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, "authenticated", grantee, grantOption);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRevokeSchemaPrivilege(CHARLIE, privilege, "test", grantee, grantOption));
    }

    @DataProvider(name="privilegeGrantOption")
    public Object[][] privilegeGrantOption() {
        return (Object[][])EnumSet.allOf(Privilege.class).stream().flatMap(privilege -> Stream.of(true, false).map(grantOption -> new Object[]{privilege, grantOption})).toArray(x$0 -> new Object[x$0][]);
    }

    @Test
    public void testTableRules() {
        SchemaTableName testTable = new SchemaTableName("test", "test");
        SchemaTableName aliceTable = new SchemaTableName("aliceschema", "alicetable");
        SchemaTableName bobTable = new SchemaTableName("bobschema", "bobtable");
        ConnectorAccessControl accessControl = this.createAccessControl("table.json");
        accessControl.checkCanSelectFromColumns(ALICE, testTable, (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(ALICE, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(ALICE, bobTable, (Set)ImmutableSet.of((Object)"bobcolumn"));
        accessControl.checkCanShowColumns(ALICE, bobTable);
        Assert.assertEquals((Set)accessControl.filterColumns(ALICE, bobTable, (Set)ImmutableSet.of((Object)"a")), (Set)ImmutableSet.of((Object)"a"));
        accessControl.checkCanSelectFromColumns(BOB, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanShowColumns(BOB, bobTable);
        Assert.assertEquals((Set)accessControl.filterColumns(BOB, bobTable, (Set)ImmutableSet.of((Object)"a")), (Set)ImmutableSet.of((Object)"a"));
        accessControl.checkCanInsertIntoTable(BOB, bobTable);
        accessControl.checkCanDeleteFromTable(BOB, bobTable);
        accessControl.checkCanTruncateTable(BOB, bobTable);
        accessControl.checkCanSelectFromColumns(CHARLIE, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanSelectFromColumns(CHARLIE, bobTable, (Set)ImmutableSet.of((Object)"bobcolumn"));
        accessControl.checkCanInsertIntoTable(CHARLIE, bobTable);
        accessControl.checkCanSelectFromColumns(JOE, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanCreateTable(ADMIN, new SchemaTableName("bob", "test"), Map.of());
        accessControl.checkCanCreateTable(ADMIN, testTable, Map.of());
        accessControl.checkCanCreateTable(ADMIN, new SchemaTableName("authenticated", "test"), Map.of());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(ADMIN, new SchemaTableName("secret", "test"), Map.of()));
        accessControl.checkCanCreateTable(ALICE, new SchemaTableName("aliceschema", "test"), Map.of());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(ALICE, testTable, Map.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(CHARLIE, new SchemaTableName("aliceschema", "test"), Map.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(CHARLIE, testTable, Map.of()));
        accessControl.checkCanCreateViewWithSelectFromColumns(BOB, bobTable, (Set)ImmutableSet.of());
        accessControl.checkCanDropTable(ADMIN, bobTable);
        accessControl.checkCanTruncateTable(ADMIN, bobTable);
        accessControl.checkCanRenameTable(ADMIN, bobTable, new SchemaTableName("aliceschema", "newbobtable"));
        accessControl.checkCanRenameTable(ALICE, aliceTable, new SchemaTableName("aliceschema", "newalicetable"));
        accessControl.checkCanRenameView(ADMIN, new SchemaTableName("bobschema", "bobview"), new SchemaTableName("aliceschema", "newbobview"));
        accessControl.checkCanRenameView(ALICE, new SchemaTableName("aliceschema", "aliceview"), new SchemaTableName("aliceschema", "newaliceview"));
        accessControl.checkCanRenameMaterializedView(ADMIN, new SchemaTableName("bobschema", "bobmaterializedview"), new SchemaTableName("aliceschema", "newbobaterializedview"));
        accessControl.checkCanRenameMaterializedView(ALICE, new SchemaTableName("aliceschema", "alicevaterializediew"), new SchemaTableName("aliceschema", "newaliceaterializedview"));
        accessControl.checkCanSetMaterializedViewProperties(ADMIN, new SchemaTableName("bobschema", "bobmaterializedview"), (Map)ImmutableMap.of());
        accessControl.checkCanSetMaterializedViewProperties(ALICE, new SchemaTableName("aliceschema", "alicevaterializediew"), (Map)ImmutableMap.of());
        accessControl.checkCanSetViewComment(ALICE, new SchemaTableName("aliceschema", "aliceview"));
        accessControl.checkCanAlterColumn(ADMIN, bobTable);
        accessControl.checkCanAlterColumn(ALICE, aliceTable);
        accessControl.checkCanSetTableProperties(ADMIN, bobTable, (Map)ImmutableMap.of());
        accessControl.checkCanSetTableProperties(ALICE, aliceTable, (Map)ImmutableMap.of());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanInsertIntoTable(ALICE, bobTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropTable(BOB, bobTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameTable(BOB, bobTable, new SchemaTableName("bobschema", "newbobtable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameTable(ALICE, aliceTable, new SchemaTableName("bobschema", "newalicetable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewComment(ALICE, new SchemaTableName("bobschema", "newalicetable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanAlterColumn(BOB, bobTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableProperties(BOB, bobTable, (Map)ImmutableMap.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanInsertIntoTable(BOB, testTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSelectFromColumns(ADMIN, new SchemaTableName("secret", "secret"), (Set)ImmutableSet.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSelectFromColumns(JOE, new SchemaTableName("secret", "secret"), (Set)ImmutableSet.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateViewWithSelectFromColumns(JOE, bobTable, (Set)ImmutableSet.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameView(BOB, new SchemaTableName("bobschema", "bobview"), new SchemaTableName("bobschema", "newbobview")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameView(ALICE, aliceTable, new SchemaTableName("bobschema", "newalicetable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameMaterializedView(BOB, new SchemaTableName("bobschema", "bobmaterializedview"), new SchemaTableName("bobschema", "newbobaterializedview")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanRenameMaterializedView(ALICE, aliceTable, new SchemaTableName("bobschema", "newaliceaterializedview")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetMaterializedViewProperties(ALICE, new SchemaTableName("bobschema", "bobmaterializedview"), (Map)ImmutableMap.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetMaterializedViewProperties(BOB, new SchemaTableName("bobschema", "bobmaterializedview"), (Map)ImmutableMap.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ADMIN, testTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ADMIN, testTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ALICE, aliceTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ALICE, aliceTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ALICE, bobTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(ALICE, bobTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ADMIN, testTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ADMIN, testTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ALICE, aliceTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ALICE, aliceTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ALICE, bobTable, new TrinoPrincipal(PrincipalType.ROLE, "some_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(ALICE, bobTable, new TrinoPrincipal(PrincipalType.USER, "some_user")));
    }

    @Test
    public void testTableRulesForMixedGroupUsers() {
        SchemaTableName myTable = new SchemaTableName("my_schema", "my_table");
        ConnectorAccessControl accessControl = this.createAccessControl("table-mixed-groups.json");
        ConnectorSecurityContext userGroup1Group2 = BaseFileBasedConnectorAccessControlTest.user("user_1_2", (Set<String>)ImmutableSet.of((Object)"group1", (Object)"group2"));
        ConnectorSecurityContext userGroup2 = BaseFileBasedConnectorAccessControlTest.user("user_2", (Set<String>)ImmutableSet.of((Object)"group2"));
        accessControl.checkCanCreateTable(userGroup1Group2, myTable, Map.of());
        accessControl.checkCanInsertIntoTable(userGroup1Group2, myTable);
        accessControl.checkCanDeleteFromTable(userGroup1Group2, myTable);
        accessControl.checkCanDropTable(userGroup1Group2, myTable);
        accessControl.checkCanSelectFromColumns(userGroup1Group2, myTable, (Set)ImmutableSet.of());
        Assert.assertEquals((Object)accessControl.getColumnMask(userGroup1Group2, myTable, "col_a", (Type)VarcharType.VARCHAR), Optional.empty());
        Assert.assertEquals((Collection)accessControl.getRowFilters(userGroup1Group2, myTable), (Collection)ImmutableList.of());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(userGroup2, myTable, Map.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanInsertIntoTable(userGroup2, myTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDeleteFromTable(userGroup2, myTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropTable(userGroup2, myTable));
        accessControl.checkCanSelectFromColumns(userGroup2, myTable, (Set)ImmutableSet.of());
        BaseFileBasedConnectorAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(userGroup2, myTable, "col_a", (Type)VarcharType.VARCHAR).orElseThrow(), new ViewExpression(Optional.empty(), Optional.of("test_catalog"), Optional.of("my_schema"), "'mask_a'"));
        Assert.assertEquals((Collection)accessControl.getRowFilters(userGroup2, myTable), (Collection)ImmutableList.of());
        ConnectorSecurityContext userGroup1Group3 = BaseFileBasedConnectorAccessControlTest.user("user_1_3", (Set<String>)ImmutableSet.of((Object)"group1", (Object)"group3"));
        ConnectorSecurityContext userGroup3 = BaseFileBasedConnectorAccessControlTest.user("user_3", (Set<String>)ImmutableSet.of((Object)"group3"));
        accessControl.checkCanCreateTable(userGroup1Group3, myTable, Map.of());
        accessControl.checkCanInsertIntoTable(userGroup1Group3, myTable);
        accessControl.checkCanDeleteFromTable(userGroup1Group3, myTable);
        accessControl.checkCanDropTable(userGroup1Group3, myTable);
        accessControl.checkCanSelectFromColumns(userGroup1Group3, myTable, (Set)ImmutableSet.of());
        Assert.assertEquals((Object)accessControl.getColumnMask(userGroup1Group3, myTable, "col_a", (Type)VarcharType.VARCHAR), Optional.empty());
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanCreateTable(userGroup3, myTable, Map.of()));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanInsertIntoTable(userGroup3, myTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDeleteFromTable(userGroup3, myTable));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanDropTable(userGroup3, myTable));
        accessControl.checkCanSelectFromColumns(userGroup3, myTable, (Set)ImmutableSet.of());
        BaseFileBasedConnectorAccessControlTest.assertViewExpressionEquals((ViewExpression)accessControl.getColumnMask(userGroup3, myTable, "col_a", (Type)VarcharType.VARCHAR).orElseThrow(), new ViewExpression(Optional.empty(), Optional.of("test_catalog"), Optional.of("my_schema"), "'mask_a'"));
        List rowFilters = accessControl.getRowFilters(userGroup3, myTable);
        Assert.assertEquals((int)rowFilters.size(), (int)1);
        BaseFileBasedConnectorAccessControlTest.assertViewExpressionEquals((ViewExpression)rowFilters.get(0), new ViewExpression(Optional.empty(), Optional.of("test_catalog"), Optional.of("my_schema"), "country='US'"));
    }

    private static void assertViewExpressionEquals(ViewExpression actual, ViewExpression expected) {
        Assert.assertEquals((Object)actual.getSecurityIdentity(), (Object)expected.getSecurityIdentity(), (String)"Identity");
        Assert.assertEquals((Object)actual.getCatalog(), (Object)expected.getCatalog(), (String)"Catalog");
        Assert.assertEquals((Object)actual.getSchema(), (Object)expected.getSchema(), (String)"Schema");
        Assert.assertEquals((String)actual.getExpression(), (String)expected.getExpression(), (String)"Expression");
    }

    @Test
    public void testTableFilter() {
        ConnectorAccessControl accessControl = this.createAccessControl("table-filter.json");
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("restricted", "any")).add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).add((Object)new SchemaTableName("bobschema", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assert.assertEquals((Set)accessControl.filterTables(ALICE, (Set)tables), (Set)ImmutableSet.builder().add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).build());
        Assert.assertEquals((Set)accessControl.filterTables(BOB, (Set)tables), (Set)ImmutableSet.builder().add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).build());
        Assert.assertEquals((Set)accessControl.filterTables(ADMIN, (Set)tables), (Set)ImmutableSet.builder().add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("aliceschema", "any")).add((Object)new SchemaTableName("aliceschema", "bobtable")).add((Object)new SchemaTableName("bobschema", "bob_any")).add((Object)new SchemaTableName("bobschema", "any")).add((Object)new SchemaTableName("any", "any")).build());
    }

    @Test
    public void testNoTableRules() {
        ConnectorAccessControl accessControl = this.createAccessControl("no-access.json");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowColumns(BOB, new SchemaTableName("bobschema", "bobtable")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(BOB, "bobschema"));
        Assert.assertEquals((Set)accessControl.filterColumns(BOB, new SchemaTableName("bobschema", "bobtable"), (Set)ImmutableSet.of((Object)"a")), (Set)ImmutableSet.of());
        ImmutableSet tables = ImmutableSet.builder().add((Object)new SchemaTableName("restricted", "any")).add((Object)new SchemaTableName("secret", "any")).add((Object)new SchemaTableName("any", "any")).build();
        Assert.assertEquals((Set)accessControl.filterTables(ALICE, (Set)tables), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)accessControl.filterTables(BOB, (Set)tables), (Set)ImmutableSet.of());
    }

    @Test
    public void testNoFunctionRules() {
        ConnectorAccessControl accessControl = this.createAccessControl("no-access.json");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.AGGREGATE, new SchemaRoutineName("schema", "some_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.SCALAR, new SchemaRoutineName("schema", "some_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.WINDOW, new SchemaRoutineName("schema", "some_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.AGGREGATE, new SchemaRoutineName("schema", "some_function"), new TrinoPrincipal(PrincipalType.USER, "some_user"), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.SCALAR, new SchemaRoutineName("schema", "some_function"), new TrinoPrincipal(PrincipalType.USER, "some_user"), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, "some_user"), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.WINDOW, new SchemaRoutineName("schema", "some_function"), new TrinoPrincipal(PrincipalType.USER, "some_user"), true));
    }

    @Test
    public void testSessionPropertyRules() {
        ConnectorAccessControl accessControl = this.createAccessControl("session_property.json");
        accessControl.checkCanSetCatalogSessionProperty(ADMIN, "dangerous");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "safe");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "unsafe");
        accessControl.checkCanSetCatalogSessionProperty(ALICE, "staff");
        accessControl.checkCanSetCatalogSessionProperty(BOB, "safe");
        accessControl.checkCanSetCatalogSessionProperty(BOB, "staff");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(BOB, "unsafe"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(ALICE, "dangerous"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(CHARLIE, "safe"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(CHARLIE, "staff"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetCatalogSessionProperty(JOE, "staff"));
    }

    @Test
    public void testFilterSchemas() {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        BaseFileBasedConnectorAccessControlTest.assertFilterSchemas(accessControl);
    }

    private static void assertFilterSchemas(ConnectorAccessControl accessControl) {
        ImmutableSet allSchemas = ImmutableSet.of((Object)"specific-schema", (Object)"alice-schema", (Object)"bob-schema", (Object)"unknown", (Object)"ptf_schema");
        Assert.assertEquals((Set)accessControl.filterSchemas(ADMIN, (Set)allSchemas), (Set)allSchemas);
        Assert.assertEquals((Set)accessControl.filterSchemas(ALICE, (Set)allSchemas), (Set)ImmutableSet.of((Object)"specific-schema", (Object)"alice-schema", (Object)"ptf_schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(BOB, (Set)allSchemas), (Set)ImmutableSet.of((Object)"specific-schema", (Object)"bob-schema"));
        Assert.assertEquals((Set)accessControl.filterSchemas(CHARLIE, (Set)allSchemas), (Set)ImmutableSet.of((Object)"specific-schema"));
    }

    @Test
    public void testSchemaRulesForCheckCanShowTables() {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        accessControl.checkCanShowTables(ADMIN, "specific-schema");
        accessControl.checkCanShowTables(ADMIN, "bob-schema");
        accessControl.checkCanShowTables(ADMIN, "alice-schema");
        accessControl.checkCanShowTables(ADMIN, "secret");
        accessControl.checkCanShowTables(ADMIN, "any");
        accessControl.checkCanShowTables(ALICE, "specific-schema");
        accessControl.checkCanShowTables(ALICE, "alice-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(ALICE, "bob-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(ALICE, "secret"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(ALICE, "any"));
        accessControl.checkCanShowTables(BOB, "specific-schema");
        accessControl.checkCanShowTables(BOB, "bob-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(BOB, "alice-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(BOB, "secret"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(BOB, "any"));
        accessControl.checkCanShowTables(CHARLIE, "specific-schema");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(CHARLIE, "bob-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(CHARLIE, "alice-schema"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(CHARLIE, "secret"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanShowTables(CHARLIE, "any"));
    }

    @Test
    public void testFunctionRulesForCheckCanExecute() {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ADMIN, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function")));
        accessControl.checkCanExecuteFunction(ALICE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(BOB, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(CHARLIE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ADMIN, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(ALICE, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function")));
        accessControl.checkCanExecuteFunction(BOB, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function"));
        accessControl.checkCanExecuteFunction(BOB, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function"));
        accessControl.checkCanExecuteFunction(BOB, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(CHARLIE, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(CHARLIE, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanExecuteFunction(CHARLIE, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function")));
    }

    @Test
    public void testFunctionRulesForCheckCanGrantExecute() {
        ConnectorAccessControl accessControl = this.createAccessControl("visibility.json");
        accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, ADMIN.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true);
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_function"), new TrinoPrincipal(PrincipalType.USER, ADMIN.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(ALICE, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, ADMIN.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_table_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.TABLE, new SchemaRoutineName("ptf_schema", "some_function"), new TrinoPrincipal(PrincipalType.USER, ADMIN.getIdentity().getUser()), true));
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, ALICE.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, BOB.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.AGGREGATE, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.SCALAR, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true);
        accessControl.checkCanGrantExecuteFunctionPrivilege(BOB, FunctionKind.WINDOW, new SchemaRoutineName("any", "some_function"), new TrinoPrincipal(PrincipalType.USER, CHARLIE.getIdentity().getUser()), true);
    }

    @Test
    public void testInvalidRules() {
        Assertions.assertThatThrownBy(() -> this.createAccessControl("invalid.json")).hasMessageContaining("Failed to convert JSON tree node");
    }

    @Test
    public void testFilterSchemasWithJsonPointer() {
        File configFile = new File(this.getResourcePath("visibility-with-json-pointer.json"));
        ConnectorAccessControl accessControl = this.createAccessControl(configFile, (Map<String, String>)ImmutableMap.of((Object)"security.json-pointer", (Object)"/data"));
        BaseFileBasedConnectorAccessControlTest.assertFilterSchemas(accessControl);
    }

    @Test
    public void testSchemaAuthorization() {
        ConnectorAccessControl accessControl = this.createAccessControl("authorization-no-roles.json");
        String schema = "test";
        String ownedByUser = "owned_by_user";
        String ownedByGroup = "owned_by_group";
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "group"), schema, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_DENY_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("DENY_authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetSchemaAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
    }

    @Test
    public void testTableAuthorization() {
        ConnectorAccessControl accessControl = this.createAccessControl("authorization-no-roles.json");
        SchemaTableName table = new SchemaTableName("test", "table");
        SchemaTableName ownedByUser = new SchemaTableName("test", "owned_by_user");
        SchemaTableName ownedByGroup = new SchemaTableName("test", "owned_by_group");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "group"), table, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_DENY_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetTableAuthorization(BaseFileBasedConnectorAccessControlTest.user("DENY_authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
    }

    @Test
    public void testViewAuthorization() {
        ConnectorAccessControl accessControl = this.createAccessControl("authorization-no-roles.json");
        SchemaTableName table = new SchemaTableName("test", "table");
        SchemaTableName ownedByUser = new SchemaTableName("test", "owned_by_user");
        SchemaTableName ownedByGroup = new SchemaTableName("test", "owned_by_group");
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "group"), table, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_DENY_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("owner_authorized", "group"), ownedByUser, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
        accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user"));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("DENY_authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("user", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.USER, "new_user")));
        BaseFileBasedConnectorAccessControlTest.assertDenied(() -> accessControl.checkCanSetViewAuthorization(BaseFileBasedConnectorAccessControlTest.user("authorized", "owner"), ownedByGroup, new TrinoPrincipal(PrincipalType.ROLE, "new_role")));
    }

    @Test
    public void testEverythingImplemented() throws NoSuchMethodException {
        InterfaceTestUtils.assertAllMethodsOverridden(ConnectorAccessControl.class, FileBasedAccessControl.class);
    }

    @Test
    public void testRefreshing() throws Exception {
        File configFile = Files.newTemporaryFile();
        configFile.deleteOnExit();
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("visibility.json")), (File)configFile);
        ConnectorAccessControl accessControl = this.createAccessControl(configFile, (Map<String, String>)ImmutableMap.of((Object)"security.refresh-period", (Object)"1ms"));
        accessControl.checkCanShowTables(ALICE, "alice-schema");
        accessControl.checkCanShowTables(ALICE, "alice-schema");
        accessControl.checkCanShowTables(ALICE, "alice-schema");
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("no-access.json")), (File)configFile);
        Thread.sleep(2L);
        Assertions.assertThatThrownBy(() -> accessControl.checkCanShowTables(ALICE, "alice-schema")).hasMessageContaining("Access Denied");
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("visibility.json")), (File)configFile);
        Thread.sleep(2L);
        accessControl.checkCanShowTables(ALICE, "alice-schema");
    }

    protected ConnectorAccessControl createAccessControl(Map<String, String> configProperties) {
        Bootstrap bootstrap = new Bootstrap(new Module[]{new CatalogNameModule("test_catalog"), new FileBasedAccessControlModule()});
        Injector injector = bootstrap.doNotInitializeLogging().setRequiredConfigurationProperties(configProperties).initialize();
        return (ConnectorAccessControl)injector.getInstance(ConnectorAccessControl.class);
    }

    private ConnectorAccessControl createAccessControl(String rulesName) {
        File configFile = new File(this.getResourcePath(rulesName));
        return this.createAccessControl(configFile, (Map<String, String>)ImmutableMap.of());
    }

    private String getResourcePath(String resourceName) {
        return Objects.requireNonNull(this.getClass().getClassLoader().getResource(resourceName), "Resource does not exist: " + resourceName).getPath();
    }

    private static ConnectorSecurityContext user(String user, String group) {
        return BaseFileBasedConnectorAccessControlTest.user(user, (Set<String>)ImmutableSet.of((Object)group));
    }

    private static ConnectorSecurityContext user(String name, Set<String> groups) {
        return new ConnectorSecurityContext(new ConnectorTransactionHandle(){}, ConnectorIdentity.forUser((String)name).withGroups(groups).build(), new QueryId("query_id"));
    }

    private static void assertDenied(Assert.ThrowingRunnable runnable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Assert.ThrowingRunnable)runnable).run()).isInstanceOf(AccessDeniedException.class)).hasMessageStartingWith("Access Denied");
    }

    private static /* synthetic */ void lambda$testSchemaRules$15(ConnectorAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, "test", properties);
    }

    private static /* synthetic */ void lambda$testSchemaRules$14(ConnectorAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, "staff", properties);
    }

    private static /* synthetic */ void lambda$testSchemaRules$13(ConnectorAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(CHARLIE, "bob", properties);
    }

    private static /* synthetic */ void lambda$testSchemaRules$12(ConnectorAccessControl accessControl, Map properties) throws Throwable {
        accessControl.checkCanCreateSchema(BOB, "test", properties);
    }
}

