/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.authentication;

import io.trino.plugin.base.authentication.KerberosConfiguration;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestKerberosConfiguration {
    private static final String HOST_NAME = "host_name";

    @Test(dataProvider="kerberosPrincipalPattern")
    public void testHostnameSubstitution(String actual, String expected) {
        Assertions.assertThat((String)KerberosConfiguration.Builder.getServerPrincipal((String)actual, (String)HOST_NAME)).isEqualTo(expected);
    }

    @DataProvider(name="kerberosPrincipalPattern")
    public Object[][] kerberosPrincipalPattern() {
        return new Object[][]{{"server/_HOST@REALM.COM", "server/host_name@REALM.COM"}, {"server/_HOST", "server/host_name"}, {"server/trino-worker@REALM.COM", "server/trino-worker@REALM.COM"}, {"server/trino-worker", "server/trino-worker"}, {"SERVER_HOST/_HOST@REALM.COM", "SERVER_HOST/host_name@REALM.COM"}, {"SERVER_HOST/_HOST", "SERVER_HOST/host_name"}};
    }
}

