/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.MaxDomainCompactionThreshold;
import io.trino.plugin.jdbc.RetryingConnectionFactory;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.plugin.oracle.OracleClient;
import io.trino.plugin.oracle.OracleConfig;
import io.trino.plugin.oracle.OraclePoolConnectionFactory;
import io.trino.plugin.oracle.OracleSessionProperties;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Properties;
import oracle.jdbc.OracleDriver;

public class OracleClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(OracleClient.class).in(Scopes.SINGLETON);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, OracleSessionProperties.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OracleConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Integer.TYPE, MaxDomainCompactionThreshold.class)).setBinding().toInstance((Object)1000);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, RetryingConnectionFactory.RetryStrategy.class).setBinding().to(OracleRetryStrategy.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory connectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider, OracleConfig oracleConfig, OpenTelemetry openTelemetry) throws SQLException {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("includeSynonyms", String.valueOf(oracleConfig.isSynonymsEnabled()));
        connectionProperties.setProperty("remarksReporting", String.valueOf(oracleConfig.isRemarksReportingEnabled()));
        if (oracleConfig.isConnectionPoolEnabled()) {
            return new OraclePoolConnectionFactory(config.getConnectionUrl(), connectionProperties, credentialProvider, oracleConfig.getConnectionPoolMinSize(), oracleConfig.getConnectionPoolMaxSize(), oracleConfig.getInactiveConnectionTimeout(), openTelemetry);
        }
        return new DriverConnectionFactory((Driver)new OracleDriver(), config.getConnectionUrl(), connectionProperties, credentialProvider, openTelemetry);
    }

    private static class OracleRetryStrategy
    implements RetryingConnectionFactory.RetryStrategy {
        private OracleRetryStrategy() {
        }

        public boolean isExceptionRecoverable(Throwable exception) {
            return Throwables.getCausalChain((Throwable)exception).stream().anyMatch(SQLRecoverableException.class::isInstance);
        }
    }
}

