/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.locator.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ClasspathBuilder {
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private final List<String> parts = new ArrayList<String>();
    private String extension = null;

    public ClasspathBuilder setExtension(@Nullable String extension) {
        String trimmed;
        if (extension != null && !(trimmed = extension.trim()).isEmpty()) {
            this.extension = trimmed;
        }
        return this;
    }

    public ClasspathBuilder appendFullyQualifiedClassName(@NonNull Class<?> clazz) {
        return this.appendDotPath(clazz.getName());
    }

    public ClasspathBuilder appendDotPath(@NonNull String path) {
        return this.appendVerbatim(path.replace(DOT, SLASH));
    }

    public ClasspathBuilder appendVerbatim(@NonNull String s) {
        return this.addCarefully(s);
    }

    private ClasspathBuilder addCarefully(@Nullable String part) {
        String clean = ClasspathBuilder.sanitize(part);
        if (clean != null) {
            this.parts.add(clean);
        }
        return this;
    }

    public String build() {
        if (this.parts.isEmpty()) {
            throw new IllegalStateException("specify path parts before building the path");
        }
        StringBuilder sb = new StringBuilder();
        for (String part : this.parts) {
            sb.append(part).append(SLASH);
        }
        sb.deleteCharAt(sb.length() - 1);
        if (this.extension != null) {
            sb.append(DOT).append(this.extension);
        }
        return sb.toString();
    }

    public String toString() {
        return this.extension == null ? this.parts.toString() : this.parts.toString() + " + ." + this.extension;
    }

    @Nullable
    private static String sanitize(String path) {
        if (path == null || path.isEmpty() || SLASH.equals(path)) {
            return null;
        }
        String sanitized = Arrays.stream(path.split(Pattern.quote(SLASH))).map(String::trim).filter(part -> !part.isEmpty()).collect(Collectors.joining(SLASH));
        return sanitized.isEmpty() ? null : sanitized;
    }
}

