/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mysql;

import com.google.common.base.Strings;
import com.mysql.cj.conf.ConnectionUrlParser;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.jdbc.Driver;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import jakarta.validation.constraints.AssertTrue;
import java.sql.SQLException;

public class MySqlJdbcConfig
extends BaseJdbcConfig {
    @AssertTrue(message="Invalid JDBC URL for MySQL connector")
    public @AssertTrue(message="Invalid JDBC URL for MySQL connector") boolean isUrlValid() {
        try {
            return new Driver().acceptsURL(this.getConnectionUrl());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @AssertTrue(message="Database (catalog) must not be specified in JDBC URL for MySQL connector")
    public @AssertTrue(message="Database (catalog) must not be specified in JDBC URL for MySQL connector") boolean isUrlWithoutDatabase() {
        try {
            ConnectionUrlParser parser = ConnectionUrlParser.parseConnectionString((String)this.getConnectionUrl());
            return Strings.isNullOrEmpty((String)parser.getPath());
        }
        catch (CJException ignore) {
            return false;
        }
    }
}

