/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mariadb;

import io.trino.plugin.jdbc.BaseJdbcConfig;
import jakarta.validation.constraints.AssertTrue;
import java.sql.SQLException;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.Driver;

public class MariaDbJdbcConfig
extends BaseJdbcConfig {
    @AssertTrue(message="Invalid JDBC URL for MariaDB connector")
    public @AssertTrue(message="Invalid JDBC URL for MariaDB connector") boolean isUrlValid() {
        Driver driver = new Driver();
        return driver.acceptsURL(this.getConnectionUrl());
    }

    @AssertTrue(message="Database (catalog) must not be specified in JDBC URL for MariaDB connector")
    public @AssertTrue(message="Database (catalog) must not be specified in JDBC URL for MariaDB connector") boolean isUrlWithoutDatabase() {
        try {
            Configuration conf = Configuration.parse((String)this.getConnectionUrl());
            if (conf == null) {
                return false;
            }
            return conf.database() == null;
        }
        catch (SQLException e) {
            return false;
        }
    }
}

