/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.localfile;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.localfile.LocalFileConnector;
import io.trino.plugin.localfile.LocalFileHandleResolver;
import io.trino.plugin.localfile.LocalFileModule;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorHandleResolver;
import java.util.Map;
import java.util.Objects;

public class LocalFileConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "localfile";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new LocalFileHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager()), new LocalFileModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(LocalFileConnector.class);
    }
}

