/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.plugin.kinesis.KinesisCompressionCodec;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public class KinesisTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final String streamName;
    private final String messageDataFormat;
    private final KinesisCompressionCodec compressionCodec;

    @JsonCreator
    public KinesisTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="streamName") String streamName, @JsonProperty(value="messageDataFormat") String messageDataFormat, @JsonProperty(value="compressionCodec") KinesisCompressionCodec compressionCodec) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.streamName = Objects.requireNonNull(streamName, "streamName is null");
        this.messageDataFormat = Objects.requireNonNull(messageDataFormat, "messageDataFormat is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getStreamName() {
        return this.streamName;
    }

    @JsonProperty
    public String getMessageDataFormat() {
        return this.messageDataFormat;
    }

    @JsonProperty
    public KinesisCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaName, this.tableName, this.streamName, this.messageDataFormat, this.compressionCodec});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KinesisTableHandle other = (KinesisTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.streamName, other.streamName) && Objects.equals(this.messageDataFormat, other.messageDataFormat) && Objects.equals((Object)this.compressionCodec, (Object)other.compressionCodec);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("streamName", (Object)this.streamName).add("messageDataFormat", (Object)this.messageDataFormat).add("compressionCodec", (Object)this.compressionCodec).toString();
    }
}

