/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.kinesis.KinesisCompressionCodec;
import io.trino.plugin.kinesis.KinesisStreamFieldDescription;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class KinesisStreamFieldGroup {
    private final String dataFormat;
    private final Optional<KinesisCompressionCodec> compressionCodec;
    private final List<KinesisStreamFieldDescription> fields;

    @JsonCreator
    public KinesisStreamFieldGroup(@JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="compressionCodec") Optional<KinesisCompressionCodec> compressionCodec, @JsonProperty(value="fields") List<KinesisStreamFieldDescription> fields) {
        this.dataFormat = Objects.requireNonNull(dataFormat, "dataFormat is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields is null"));
    }

    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    public KinesisCompressionCodec getCompressionCodec() {
        return this.compressionCodec.orElse(KinesisCompressionCodec.UNCOMPRESSED);
    }

    @JsonProperty
    public List<KinesisStreamFieldDescription> getFields() {
        return this.fields;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataFormat", (Object)this.dataFormat).add("compressionCodec", this.compressionCodec).add("fields", this.fields).toString();
    }
}

