/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jmx;

import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.jmx.JmxConnectorConfig;
import io.trino.plugin.jmx.JmxMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxHistoricalData {
    private final Set<String> tables;
    private final Map<String, EvictingQueue<List<Object>>> tableData = new HashMap<String, EvictingQueue<List<Object>>>();

    @Inject
    public JmxHistoricalData(JmxConnectorConfig jmxConfig, MBeanServer mbeanServer) {
        this(jmxConfig.getMaxEntries(), jmxConfig.getDumpTables(), mbeanServer);
    }

    public JmxHistoricalData(int maxEntries, Set<String> tableNames, MBeanServer mbeanServer) {
        this.tables = (Set)tableNames.stream().map(objectNamePattern -> JmxMetadata.toPattern(objectNamePattern.toLowerCase(Locale.ENGLISH))).flatMap(objectNamePattern -> mbeanServer.queryNames(ObjectName.WILDCARD, null).stream().map(objectName -> objectName.getCanonicalName().toLowerCase(Locale.ENGLISH)).filter(name -> name.matches((String)objectNamePattern))).collect(ImmutableSet.toImmutableSet());
        for (String tableName : this.tables) {
            this.tableData.put(tableName, (EvictingQueue<List<Object>>)EvictingQueue.create((int)maxEntries));
        }
    }

    public Set<String> getTables() {
        return this.tables;
    }

    public synchronized void addRow(String tableName, List<Object> row) {
        String lowerCaseTableName = tableName.toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((boolean)this.tableData.containsKey(lowerCaseTableName));
        this.tableData.get(lowerCaseTableName).add(row);
    }

    public synchronized List<List<Object>> getRows(String objectName, List<Integer> selectedColumns) {
        String lowerCaseObjectName = objectName.toLowerCase(Locale.ENGLISH);
        if (!this.tableData.containsKey(lowerCaseObjectName)) {
            return ImmutableList.of();
        }
        return this.projectRows((Collection)this.tableData.get(lowerCaseObjectName), selectedColumns);
    }

    private List<List<Object>> projectRows(Collection<List<Object>> rows, List<Integer> selectedColumns) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (List<Object> row : rows) {
            ArrayList<Object> projectedRow = new ArrayList<Object>();
            for (Integer selectedColumn : selectedColumns) {
                projectedRow.add(row.get(selectedColumn));
            }
            result.add(projectedRow);
        }
        return result.build();
    }
}

