/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.subscription;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.metastorage.DistributedMetastorageLifecycleListener;
import org.apache.ignite.internal.processors.query.schema.SchemaChangeListener;
import org.jetbrains.annotations.NotNull;

public class GridInternalSubscriptionProcessor
extends GridProcessorAdapter {
    private final List<MetastorageLifecycleListener> metastorageListeners = new ArrayList<MetastorageLifecycleListener>();
    private final List<SchemaChangeListener> schemaChangeListeners = new ArrayList<SchemaChangeListener>();
    private final List<DistributedMetastorageLifecycleListener> distributedMetastorageListeners = new ArrayList<DistributedMetastorageLifecycleListener>();
    private final List<DatabaseLifecycleListener> dbListeners = new ArrayList<DatabaseLifecycleListener>();
    private List<DistributedConfigurationLifecycleListener> distributedConfigurationListeners = new ArrayList<DistributedConfigurationLifecycleListener>();

    public GridInternalSubscriptionProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    public void registerMetastorageListener(@NotNull MetastorageLifecycleListener metastorageListener) {
        Objects.requireNonNull(metastorageListener, "Metastorage subscriber should be not-null.");
        this.metastorageListeners.add(metastorageListener);
    }

    public List<MetastorageLifecycleListener> getMetastorageSubscribers() {
        return this.metastorageListeners;
    }

    public void registerSchemaChangeListener(@NotNull SchemaChangeListener schemaChangeListener) {
        Objects.requireNonNull(schemaChangeListener, "Schema change event subscriber should be not-null.");
        this.schemaChangeListeners.add(schemaChangeListener);
    }

    public List<SchemaChangeListener> getSchemaChangeSubscribers() {
        return this.schemaChangeListeners;
    }

    public void registerDistributedMetastorageListener(@NotNull DistributedMetastorageLifecycleListener lsnr) {
        Objects.requireNonNull(lsnr, "Global metastorage subscriber should be not-null.");
        this.distributedMetastorageListeners.add(lsnr);
    }

    public List<DistributedMetastorageLifecycleListener> getDistributedMetastorageSubscribers() {
        return this.distributedMetastorageListeners;
    }

    public void registerDatabaseListener(@NotNull DatabaseLifecycleListener databaseListener) {
        Objects.requireNonNull(databaseListener, "Database subscriber should be not-null.");
        this.dbListeners.add(databaseListener);
    }

    public List<DatabaseLifecycleListener> getDatabaseListeners() {
        return this.dbListeners;
    }

    public void registerDistributedConfigurationListener(@NotNull DistributedConfigurationLifecycleListener lifecycleListener) {
        Objects.requireNonNull(this.distributedConfigurationListeners, "Distributed configuration subscriber should be not-null.");
        this.distributedConfigurationListeners.add(lifecycleListener);
    }

    public List<DistributedConfigurationLifecycleListener> getDistributedConfigurationListeners() {
        return this.distributedConfigurationListeners;
    }
}

