/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDataRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.internal.util.typedef.F;

public abstract class ClientCacheKeyRequest
extends ClientCacheDataRequest
implements ClientTxAwareRequest {
    private final Object key;

    ClientCacheKeyRequest(BinaryRawReaderEx reader) {
        super(reader);
        this.key = reader.readObjectDetached();
    }

    @Override
    public final ClientResponse process(ClientConnectionContext ctx) {
        DynamicCacheDescriptor desc;
        CacheConfiguration cfg;
        if (!this.isTransactional() && (cfg = (desc = this.cacheDescriptor(ctx)).cacheConfiguration()).getCacheMode() == CacheMode.PARTITIONED && cfg.isStatisticsEnabled()) {
            String cacheName = desc.cacheName();
            try {
                GridKernalContext kctx = ctx.kernalContext();
                if (F.first(kctx.affinity().mapKeyToPrimaryAndBackups(cacheName, this.key, null)).isLocal()) {
                    kctx.clientListener().metrics().onAffinityKeyHit();
                } else {
                    kctx.clientListener().metrics().onAffinityKeyMiss();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.process0(ctx);
    }

    protected abstract ClientResponse process0(ClientConnectionContext var1);

    public Object key() {
        return this.key;
    }
}

