/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.localtask;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTask;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DurableBackgroundTaskState<R> {
    private static final AtomicReferenceFieldUpdater<DurableBackgroundTaskState, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DurableBackgroundTaskState.class, State.class, "state");
    private final DurableBackgroundTask<R> task;
    private final GridFutureAdapter<R> outFut;
    private final boolean saved;
    private volatile State state = State.INIT;
    private final boolean converted;

    public DurableBackgroundTaskState(DurableBackgroundTask<R> task, GridFutureAdapter<R> outFut, boolean saved, boolean converted) {
        this.task = task;
        this.outFut = outFut;
        this.saved = saved;
        this.converted = converted;
    }

    public DurableBackgroundTask<R> task() {
        return this.task;
    }

    public GridFutureAdapter<R> outFuture() {
        return this.outFut;
    }

    public boolean saved() {
        return this.saved;
    }

    public State state() {
        return this.state;
    }

    public void state(State s2) {
        this.state = s2;
    }

    public boolean state(State exp, State newState) {
        return STATE_UPDATER.compareAndSet(this, exp, newState);
    }

    public boolean converted() {
        return this.converted;
    }

    public String toString() {
        return S.toString(DurableBackgroundTaskState.class, this);
    }

    public static enum State {
        INIT,
        PREPARE,
        STARTED,
        COMPLETED;

    }
}

