/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.query.BulkLoadContextCursor;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.jdbc2.JdbcQueryTask;
import org.apache.ignite.internal.jdbc2.JdbcStatementResultInfo;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

class JdbcQueryMultipleStatementsTask
implements IgniteCallable<List<JdbcStatementResultInfo>> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private Ignite ignite;
    private final String schemaName;
    private final String sql;
    private Boolean isQry;
    private final Object[] args;
    private final int fetchSize;
    private final boolean loc;
    private final boolean locQry;
    private final boolean collocatedQry;
    private final boolean distributedJoins;
    private final boolean enforceJoinOrder;
    private final boolean lazy;

    public JdbcQueryMultipleStatementsTask(Ignite ignite, String schemaName, String sql, Boolean isQry, boolean loc, Object[] args, int fetchSize, boolean locQry, boolean collocatedQry, boolean distributedJoins, boolean enforceJoinOrder, boolean lazy) {
        this.ignite = ignite;
        this.args = args;
        this.schemaName = schemaName;
        this.sql = sql;
        this.isQry = isQry;
        this.fetchSize = fetchSize;
        this.loc = loc;
        this.locQry = locQry;
        this.collocatedQry = collocatedQry;
        this.distributedJoins = distributedJoins;
        this.enforceJoinOrder = enforceJoinOrder;
        this.lazy = lazy;
    }

    @Override
    public List<JdbcStatementResultInfo> call() throws Exception {
        SqlFieldsQuery qry = (this.isQry != null ? new SqlFieldsQueryEx(this.sql, this.isQry) : new SqlFieldsQuery(this.sql)).setArgs(this.args);
        qry.setPageSize(this.fetchSize);
        qry.setLocal(this.locQry);
        qry.setCollocated(this.collocatedQry);
        qry.setDistributedJoins(this.distributedJoins);
        qry.setEnforceJoinOrder(this.enforceJoinOrder);
        qry.setLazy(this.lazy);
        qry.setSchema(this.schemaName);
        if (!F.isEmpty(this.queryInitiatorId())) {
            qry.setQueryInitiatorId(this.queryInitiatorId());
        }
        GridKernalContext ctx = ((IgniteKernal)this.ignite).context();
        List<FieldsQueryCursor<List<?>>> curs = ctx.query().querySqlFields(qry, true, !this.allowMultipleStatements());
        ArrayList<JdbcStatementResultInfo> resultsInfo = new ArrayList<JdbcStatementResultInfo>(curs.size());
        for (FieldsQueryCursor<List<?>> cur0 : curs) {
            if (cur0 instanceof BulkLoadContextCursor) {
                curs.forEach(QueryCursor::close);
                throw new SQLException("COPY command is currently supported only in thin JDBC driver.");
            }
            QueryCursorImpl cur = (QueryCursorImpl)cur0;
            long updCnt = -1L;
            UUID qryId = null;
            if (!cur.isQuery()) {
                List items = cur.getAll();
                assert (items != null && items.size() == 1 && ((List)items.get(0)).size() == 1 && ((List)items.get(0)).get(0) instanceof Long) : "Invalid result set for not-SELECT query. [qry=" + this.sql + ", res=" + S.toString(List.class, items) + ']';
                updCnt = (Long)((List)items.get(0)).get(0);
                cur.close();
            } else {
                qryId = UUID.randomUUID();
                JdbcQueryTask.Cursor jdbcCur = new JdbcQueryTask.Cursor(cur, cur.iterator());
                JdbcQueryTask.addCursor(qryId, jdbcCur);
                if (!this.loc) {
                    JdbcQueryTask.scheduleRemoval(qryId);
                }
            }
            JdbcStatementResultInfo resInfo = new JdbcStatementResultInfo(cur.isQuery(), qryId, updCnt);
            resultsInfo.add(resInfo);
        }
        return resultsInfo;
    }

    protected boolean allowMultipleStatements() {
        return true;
    }

    protected String queryInitiatorId() {
        return null;
    }
}

