/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.task.TaskExecutionOptions;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.resources.JobContextResource;
import org.apache.ignite.resources.LoggerResource;

class VisorIdleVerifyJob<ResultT>
extends VisorJob<VisorIdleVerifyTaskArg, ResultT> {
    private static final long serialVersionUID = 0L;
    private IgniteInternalFuture<ResultT> fut;
    @JobContextResource
    protected transient ComputeJobContext jobCtx;
    @LoggerResource
    private IgniteLogger log;
    private final Class<? extends ComputeTask<VisorIdleVerifyTaskArg, ResultT>> taskCls;

    VisorIdleVerifyJob(VisorIdleVerifyTaskArg arg, boolean debug, Class<? extends ComputeTask<VisorIdleVerifyTaskArg, ResultT>> taskCls) {
        super(arg, debug);
        this.taskCls = taskCls;
    }

    @Override
    protected ResultT run(VisorIdleVerifyTaskArg arg) throws IgniteException {
        try {
            if (this.fut == null) {
                this.fut = this.ignite.context().task().execute(this.taskCls, arg, TaskExecutionOptions.options(this.ignite.cluster().forServers().nodes()));
                if (!this.fut.isDone()) {
                    this.jobCtx.holdcc();
                    this.fut.listen(f -> this.jobCtx.callcc());
                    return null;
                }
            }
            return this.fut.get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void cancel() {
        this.log.warning("Idle verify was cancelled.");
        super.cancel();
    }

    public String toString() {
        return S.toString(VisorIdleVerifyJob.class, this);
    }
}

