/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.tx.TxVerboseInfo;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class VisorTxInfo
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private IgniteUuid xid;
    private long startTime;
    private long duration;
    private TransactionIsolation isolation;
    private TransactionConcurrency concurrency;
    private long timeout;
    private String lb;
    private Collection<UUID> primaryNodes;
    private TransactionState state;
    private int size;
    private IgniteUuid nearXid;
    private Collection<UUID> masterNodeIds;
    private AffinityTopologyVersion topVer;
    private TxVerboseInfo txVerboseInfo;

    public VisorTxInfo() {
    }

    public VisorTxInfo(IgniteUuid xid, long startTime, long duration, TransactionIsolation isolation, TransactionConcurrency concurrency, long timeout, String lb, Collection<UUID> primaryNodes, TransactionState state, int size, IgniteUuid nearXid, Collection<UUID> masterNodeIds, AffinityTopologyVersion topVer, TxVerboseInfo info) {
        this.xid = xid;
        this.startTime = startTime;
        this.duration = duration;
        this.isolation = isolation;
        this.concurrency = concurrency;
        this.timeout = timeout;
        this.lb = lb;
        this.primaryNodes = primaryNodes;
        this.state = state;
        this.size = size;
        this.nearXid = nearXid;
        this.masterNodeIds = masterNodeIds;
        this.topVer = topVer;
        this.txVerboseInfo = info;
    }

    public VisorTxInfo(IgniteUuid xid, TransactionState state) {
        this(xid, 0L, 0L, null, null, 0L, null, null, state, 0, null, null, null, null);
    }

    @Override
    public byte getProtocolVersion() {
        return 5;
    }

    public IgniteUuid getXid() {
        return this.xid;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getFormattedStartTime() {
        return dateTimeFormatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.startTime), TimeZone.getDefault().toZoneId()));
    }

    public long getDuration() {
        return this.duration;
    }

    public TransactionIsolation getIsolation() {
        return this.isolation;
    }

    public TransactionConcurrency getConcurrency() {
        return this.concurrency;
    }

    public AffinityTopologyVersion getTopologyVersion() {
        return this.topVer;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getLabel() {
        return this.lb;
    }

    public Collection<UUID> getPrimaryNodes() {
        return this.primaryNodes;
    }

    public TransactionState getState() {
        return this.state;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public IgniteUuid getNearXid() {
        return this.nearXid;
    }

    @Nullable
    public Collection<UUID> getMasterNodeIds() {
        return this.masterNodeIds;
    }

    public TxVerboseInfo getTxVerboseInfo() {
        return this.txVerboseInfo;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeIgniteUuid(out, this.xid);
        out.writeLong(this.duration);
        U.writeEnum(out, this.isolation);
        U.writeEnum(out, this.concurrency);
        out.writeLong(this.timeout);
        U.writeString(out, this.lb);
        U.writeCollection(out, this.primaryNodes);
        U.writeEnum(out, this.state);
        out.writeInt(this.size);
        U.writeIgniteUuid(out, this.nearXid);
        U.writeCollection(out, this.masterNodeIds);
        out.writeLong(this.startTime);
        out.writeLong(this.topVer == null ? -1L : this.topVer.topologyVersion());
        out.writeInt(this.topVer == null ? -1 : this.topVer.minorTopologyVersion());
        out.writeObject(this.txVerboseInfo);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.xid = U.readIgniteUuid(in);
        this.duration = in.readLong();
        this.isolation = TransactionIsolation.fromOrdinal(in.readByte());
        this.concurrency = TransactionConcurrency.fromOrdinal(in.readByte());
        this.timeout = in.readLong();
        this.lb = U.readString(in);
        this.primaryNodes = U.readCollection(in);
        this.state = TransactionState.fromOrdinal(in.readByte());
        this.size = in.readInt();
        if (protoVer >= 2) {
            this.nearXid = U.readIgniteUuid(in);
            this.masterNodeIds = U.readCollection(in);
            this.startTime = in.readLong();
        }
        if (protoVer >= 3) {
            long topVer = in.readLong();
            int minorTopVer = in.readInt();
            if (topVer != -1L) {
                this.topVer = new AffinityTopologyVersion(topVer, minorTopVer);
            }
        }
        if (protoVer >= 4) {
            this.txVerboseInfo = (TxVerboseInfo)in.readObject();
        }
    }

    public String toUserString() {
        return "    Tx: [xid=" + this.getXid() + ", label=" + this.getLabel() + ", state=" + (Object)((Object)this.getState()) + ", startTime=" + this.getFormattedStartTime() + ", duration=" + this.getDuration() / 1000L + " sec, isolation=" + (Object)((Object)this.getIsolation()) + ", concurrency=" + (Object)((Object)this.getConcurrency()) + ", topVer=" + (this.getTopologyVersion() == null ? "N/A" : this.getTopologyVersion()) + ", timeout=" + this.getTimeout() / 1000L + " sec, size=" + this.getSize() + ", dhtNodes=" + (this.getPrimaryNodes() == null ? "N/A" : F.transform(this.getPrimaryNodes(), new IgniteClosure<UUID, String>(){

            @Override
            public String apply(UUID id) {
                return U.id8(id);
            }
        })) + ", nearXid=" + this.getNearXid() + ", parentNodeIds=" + (this.getMasterNodeIds() == null ? "N/A" : F.transform(this.getMasterNodeIds(), new IgniteClosure<UUID, String>(){

            @Override
            public String apply(UUID id) {
                return U.id8(id);
            }
        })) + ']';
    }

    public String toString() {
        return S.toString(VisorTxInfo.class, this);
    }
}

