/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.persistence;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.persistence.PersistenceCleanAndBackupSettings;
import org.apache.ignite.internal.visor.persistence.PersistenceTaskArg;
import org.apache.ignite.internal.visor.persistence.PersistenceTaskResult;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class PersistenceTask
extends VisorOneNodeTask<PersistenceTaskArg, PersistenceTaskResult> {
    private static final long serialVersionUID = 0L;
    private static final String BACKUP_FOLDER_PREFIX = "backup_";

    @Override
    protected VisorJob<PersistenceTaskArg, PersistenceTaskResult> job(PersistenceTaskArg arg) {
        return new PersistenceJob(arg, this.debug);
    }

    private static class PersistenceJob
    extends VisorJob<PersistenceTaskArg, PersistenceTaskResult> {
        private static final long serialVersionUID = 0L;

        protected PersistenceJob(@Nullable PersistenceTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected PersistenceTaskResult run(@Nullable PersistenceTaskArg arg) throws IgniteException {
            if (!this.ignite.context().maintenanceRegistry().isMaintenanceMode()) {
                return new PersistenceTaskResult(false);
            }
            switch (arg.operation()) {
                case CLEAN: {
                    return this.clean(arg);
                }
                case BACKUP: {
                    return this.backup(arg);
                }
            }
            return this.info();
        }

        private PersistenceTaskResult backup(PersistenceTaskArg arg) {
            PersistenceCleanAndBackupSettings backupSettings = arg.cleanAndBackupSettings();
            MaintenanceRegistry mntcReg = this.ignite.context().maintenanceRegistry();
            MaintenanceTask task = mntcReg.activeMaintenanceTask("corrupted-cache-data-files-task");
            File workDir = ((FilePageStoreManager)this.ignite.context().cache().context().pageStore()).workDir();
            switch (backupSettings.cleanAndBackupType()) {
                case ALL: {
                    return this.backupAll(workDir);
                }
                case CORRUPTED: {
                    return this.backupCaches(workDir, this.corruptedCacheDirectories(task));
                }
            }
            return this.backupCaches(workDir, this.cacheDirectoriesFromCacheNames(backupSettings.cacheNames()));
        }

        private PersistenceTaskResult backupAll(File workDir) {
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            List<String> allCacheDirs = cacheProc.cacheDescriptors().values().stream().map(desc -> FilePageStoreManager.cacheDirName(desc.cacheConfiguration())).distinct().collect(Collectors.toList());
            return this.backupCaches(workDir, allCacheDirs);
        }

        private PersistenceTaskResult backupCaches(File workDir, List<String> cacheDirs) {
            PersistenceTaskResult res = new PersistenceTaskResult(true);
            ArrayList<String> backupCompletedCaches = new ArrayList<String>();
            ArrayList<String> backupFailedCaches = new ArrayList<String>();
            for (String dir : cacheDirs) {
                String backupDirName = PersistenceTask.BACKUP_FOLDER_PREFIX + dir;
                File backupDir = new File(workDir, backupDirName);
                if (backupDir.exists()) continue;
                try {
                    U.ensureDirectory(backupDir, backupDirName, null);
                    this.copyCacheFiles(workDir.toPath().resolve(dir).toFile(), backupDir);
                    backupCompletedCaches.add(backupDirName);
                }
                catch (IOException | IgniteCheckedException e) {
                    backupFailedCaches.add(dir);
                }
            }
            res.handledCaches(backupCompletedCaches);
            res.failedCaches(backupFailedCaches);
            return res;
        }

        private void copyCacheFiles(File sourceDir, File backupDir) throws IOException {
            for (File f : sourceDir.listFiles()) {
                Files.copy(f.toPath(), backupDir.toPath().resolve(f.getName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }

        private PersistenceTaskResult clean(PersistenceTaskArg arg) {
            PersistenceTaskResult res = new PersistenceTaskResult();
            PersistenceCleanAndBackupSettings cleanSettings = arg.cleanAndBackupSettings();
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            MaintenanceRegistry mntcReg = this.ignite.context().maintenanceRegistry();
            switch (cleanSettings.cleanAndBackupType()) {
                case ALL: {
                    return this.cleanAll(cacheProc, mntcReg);
                }
                case CORRUPTED: {
                    return this.cleanCorrupted(mntcReg);
                }
                case CACHES: {
                    return this.cleanCaches(cacheProc, mntcReg, cleanSettings.cacheNames());
                }
            }
            return res;
        }

        private PersistenceTaskResult cleanCaches(GridCacheProcessor cacheProc, MaintenanceRegistry mntcReg, List<String> cacheNames) {
            List<MaintenanceAction<?>> actions;
            Optional<MaintenanceAction> checkActionOpt;
            PersistenceTaskResult res = new PersistenceTaskResult(true);
            ArrayList<String> cleanedCaches = new ArrayList<String>();
            ArrayList<String> failedToCleanCaches = new ArrayList<String>();
            DataStorageConfiguration dsCfg = this.ignite.context().config().getDataStorageConfiguration();
            IgnitePageStoreManager pageStore = cacheProc.context().pageStore();
            AtomicReference missedCache = new AtomicReference();
            Boolean allExist = cacheNames.stream().map(name -> {
                if (cacheProc.cacheDescriptor((String)name) != null) {
                    return true;
                }
                missedCache.set(name);
                return false;
            }).reduce(true, (t2, u) -> t2 != false && u != false);
            if (!allExist.booleanValue()) {
                throw new IllegalArgumentException("Cache with name " + (String)missedCache.get() + " not found, no caches will be cleaned.");
            }
            for (String name2 : cacheNames) {
                DynamicCacheDescriptor cacheDescr = cacheProc.cacheDescriptor(name2);
                if (!CU.isPersistentCache(cacheDescr.cacheConfiguration(), dsCfg)) continue;
                try {
                    pageStore.cleanupPersistentSpace(cacheDescr.cacheConfiguration());
                    cleanedCaches.add(FilePageStoreManager.cacheDirName(cacheDescr.cacheConfiguration()));
                }
                catch (IgniteCheckedException e) {
                    failedToCleanCaches.add(name2);
                }
            }
            res.handledCaches(cleanedCaches);
            if (!failedToCleanCaches.isEmpty()) {
                res.failedCaches(failedToCleanCaches);
            }
            if ((checkActionOpt = (actions = mntcReg.actionsForMaintenanceTask("corrupted-cache-data-files-task")).stream().filter(a -> a.name().equals("check_cache_files_cleaned")).findFirst()).isPresent()) {
                MaintenanceAction action = checkActionOpt.get();
                Boolean mntcTaskCompleted = (Boolean)action.execute();
                res.maintenanceTaskCompleted(mntcTaskCompleted);
                if (mntcTaskCompleted.booleanValue()) {
                    mntcReg.unregisterMaintenanceTask("corrupted-cache-data-files-task");
                }
            }
            return res;
        }

        private PersistenceTaskResult cleanAll(GridCacheProcessor cacheProc, MaintenanceRegistry mntcReg) {
            PersistenceTaskResult res = new PersistenceTaskResult(true);
            List<String> allCacheDirs = cacheProc.cacheDescriptors().values().stream().map(desc -> FilePageStoreManager.cacheDirName(desc.cacheConfiguration())).collect(Collectors.toList());
            try {
                cacheProc.cleanupCachesDirectories();
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            mntcReg.unregisterMaintenanceTask("corrupted-cache-data-files-task");
            res.maintenanceTaskCompleted(true);
            res.handledCaches(allCacheDirs);
            return res;
        }

        private PersistenceTaskResult cleanCorrupted(MaintenanceRegistry mntcReg) {
            PersistenceTaskResult res = new PersistenceTaskResult(true);
            List<MaintenanceAction<?>> actions = mntcReg.actionsForMaintenanceTask("corrupted-cache-data-files-task");
            Optional<MaintenanceAction> cleanCorruptedActionOpt = actions.stream().filter(a -> a.name().equals("clean_data_files")).findFirst();
            if (cleanCorruptedActionOpt.isPresent()) {
                cleanCorruptedActionOpt.get().execute();
                MaintenanceTask corruptedTask = mntcReg.activeMaintenanceTask("corrupted-cache-data-files-task");
                mntcReg.unregisterMaintenanceTask("corrupted-cache-data-files-task");
                res.handledCaches(this.corruptedCacheDirectories(corruptedTask));
                res.maintenanceTaskCompleted(true);
            }
            return res;
        }

        private PersistenceTaskResult info() {
            PersistenceTaskResult res = new PersistenceTaskResult(true);
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            DataStorageConfiguration dsCfg = this.ignite.context().config().getDataStorageConfiguration();
            MaintenanceTask task = this.ignite.context().maintenanceRegistry().activeMaintenanceTask("corrupted-cache-data-files-task");
            if (task == null) {
                return res;
            }
            List<String> corruptedCacheNames = this.corruptedCacheDirectories(task);
            HashMap<String, IgniteBiTuple<Boolean, Boolean>> cachesInfo = new HashMap<String, IgniteBiTuple<Boolean, Boolean>>();
            for (DynamicCacheDescriptor desc : cacheProc.cacheDescriptors().values()) {
                CacheGroupDescriptor grpDesc;
                if (!CU.isPersistentCache(desc.cacheConfiguration(), dsCfg) || (grpDesc = desc.groupDescriptor()) == null) continue;
                boolean globalWalEnabled = grpDesc.walEnabled();
                boolean localWalEnabled = true;
                if (globalWalEnabled && corruptedCacheNames.contains(desc.cacheName())) {
                    localWalEnabled = false;
                }
                cachesInfo.put(desc.cacheName(), new IgniteBiTuple<Boolean, Boolean>(globalWalEnabled, localWalEnabled));
            }
            res.cachesInfo(cachesInfo);
            return res;
        }

        private List<String> corruptedCacheDirectories(MaintenanceTask task) {
            String params = task.parameters();
            String[] namesArr = params.split(Pattern.quote(File.separator));
            return Arrays.asList(namesArr);
        }

        private List<String> cacheDirectoriesFromCacheNames(List<String> cacheNames) {
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            DataStorageConfiguration dsCfg = this.ignite.configuration().getDataStorageConfiguration();
            AtomicReference missedCache = new AtomicReference();
            Boolean allExist = cacheNames.stream().map(s2 -> {
                if (cacheProc.cacheDescriptor((String)s2) != null) {
                    return true;
                }
                missedCache.set(s2);
                return false;
            }).reduce(true, (u, v) -> u != false && v != false);
            if (!allExist.booleanValue()) {
                throw new IllegalArgumentException("Cache with name " + (String)missedCache.get() + " not found, no caches will be backed up.");
            }
            return cacheNames.stream().filter(s2 -> cacheProc.cacheDescriptor((String)s2) != null).filter(s2 -> CU.isPersistentCache(cacheProc.cacheDescriptor((String)s2).cacheConfiguration(), dsCfg)).map(s2 -> cacheProc.cacheDescriptor((String)s2).cacheConfiguration()).map(FilePageStoreManager::cacheDirName).distinct().collect(Collectors.toList());
        }
    }
}

