/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security.thread;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;

class SecurityAwareCallable<T>
implements Callable<T> {
    private final Callable<T> delegate;
    private final IgniteSecurity security;
    private final SecurityContext secCtx;

    private SecurityAwareCallable(IgniteSecurity security, Callable<T> delegate) {
        assert (security.enabled());
        assert (delegate != null);
        this.delegate = delegate;
        this.security = security;
        this.secCtx = security.securityContext();
    }

    @Override
    public T call() throws Exception {
        try (OperationSecurityContext ignored = this.security.withContext(this.secCtx);){
            T t2 = this.delegate.call();
            return t2;
        }
    }

    static <A> Callable<A> of(IgniteSecurity sec, Callable<A> delegate) {
        if (delegate == null || sec.isDefaultContext()) {
            return delegate;
        }
        return new SecurityAwareCallable<A>(sec, delegate);
    }

    static <A> Collection<? extends Callable<A>> of(IgniteSecurity sec, Collection<? extends Callable<A>> tasks) {
        if (tasks == null || sec.isDefaultContext()) {
            return tasks;
        }
        return tasks.stream().map(t2 -> t2 == null ? null : new SecurityAwareCallable(sec, t2)).collect(Collectors.toList());
    }
}

