/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.cluster;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestClusterStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridChangeClusterStateCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> COMMANDS = U.sealList(GridRestCommand.CLUSTER_SET_STATE, GridRestCommand.CLUSTER_STATE);

    public GridChangeClusterStateCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest restReq) throws IgniteCheckedException {
        GridRestClusterStateRequest req = (GridRestClusterStateRequest)restReq;
        switch (req.command()) {
            case CLUSTER_STATE: {
                assert (req.isReqCurrentMode()) : req;
                return new GridFinishedFuture<GridRestResponse>(new GridRestResponse((Object)this.ctx.grid().cluster().state()));
            }
        }
        assert (req.state() != null) : req;
        U.log(this.log, "Received cluster state change request to " + (Object)((Object)req.state()) + " state from client node with ID: " + req.clientId());
        this.ctx.state().changeGlobalState(req.state(), req.forceDeactivation(), this.ctx.cluster().get().forServers().nodes(), false).get();
        return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(req.command().key() + " done"));
    }
}

