/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.hll.util;

import org.apache.ignite.internal.processors.query.stat.hll.util.NumberUtil;

public final class HLLUtil {
    private static final long[] PW_MASK = new long[]{Long.MIN_VALUE, -1L, -4L, -64L, -16384L, -1073741824L, -4611686018427387904L, -4611686018427387904L, -4611686018427387904L};
    private static final double[] TWO_TO_L = new double[279];
    private static final int REG_WIDTH_INDEX_MULTIPLIER = 31;

    public static int registerBitSize(long expectedUniqueElements) {
        return Math.max(1, (int)Math.ceil(NumberUtil.log2(NumberUtil.log2(expectedUniqueElements))));
    }

    public static double alphaMSquared(int m4) {
        switch (m4) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                throw new IllegalArgumentException("'m' cannot be less than 16 (" + m4 + " < 16).");
            }
            case 16: {
                return 0.673 * (double)m4 * (double)m4;
            }
            case 32: {
                return 0.697 * (double)m4 * (double)m4;
            }
            case 64: {
                return 0.709 * (double)m4 * (double)m4;
            }
        }
        return 0.7213 / (1.0 + 1.079 / (double)m4) * (double)m4 * (double)m4;
    }

    public static long pwMaxMask(int registerSizeInBits) {
        return PW_MASK[registerSizeInBits];
    }

    public static double smallEstimatorCutoff(int m4) {
        return (double)m4 * 5.0 / 2.0;
    }

    public static double smallEstimator(int m4, int numberOfZeroes) {
        return (double)m4 * Math.log((double)m4 / (double)numberOfZeroes);
    }

    public static double largeEstimatorCutoff(int log2m, int registerSizeInBits) {
        return TWO_TO_L[31 * registerSizeInBits + log2m] / 30.0;
    }

    public static double largeEstimator(int log2m, int registerSizeInBits, double estimator) {
        double twoToL = TWO_TO_L[31 * registerSizeInBits + log2m];
        return -1.0 * twoToL * Math.log(1.0 - estimator / twoToL);
    }

    static {
        for (int regWidth = 1; regWidth <= 8; ++regWidth) {
            for (int log2m = 4; log2m <= 30; ++log2m) {
                double twoToL;
                int maxRegisterValue = (1 << regWidth) - 1;
                int pwBits = maxRegisterValue - 1;
                int totalBits = pwBits + log2m;
                HLLUtil.TWO_TO_L[31 * regWidth + log2m] = twoToL = Math.pow(2.0, totalBits);
            }
        }
    }
}

