/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.processors.query.QueryHistoryKey;
import org.apache.ignite.internal.processors.query.QueryHistoryMetricsValue;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedDeque8;

public class QueryHistory {
    @GridToStringExclude
    private final AtomicReference<ConcurrentLinkedDeque8.Node<QueryHistory>> linkRef;
    private volatile QueryHistoryMetricsValue val;
    private final QueryHistoryKey key;

    public QueryHistory(String qry, String schema, boolean loc, long startTime, long duration, boolean failed) {
        this.key = new QueryHistoryKey(qry, schema, loc);
        long failures = failed ? 1L : 0L;
        this.val = new QueryHistoryMetricsValue(1L, failures, duration, duration, startTime);
        this.linkRef = new AtomicReference();
    }

    public QueryHistoryKey key() {
        return this.key;
    }

    public QueryHistory aggregateWithNew(QueryHistory m4) {
        this.val = new QueryHistoryMetricsValue(this.val.execs() + m4.executions(), this.val.failures() + m4.failures(), Math.min(this.val.minTime(), m4.minimumTime()), Math.max(this.val.maxTime(), m4.maximumTime()), Math.max(this.val.lastStartTime(), m4.lastStartTime()));
        return this;
    }

    public String query() {
        return this.key.query();
    }

    public String schema() {
        return this.key.schema();
    }

    public boolean local() {
        return this.key.local();
    }

    public long executions() {
        return this.val.execs();
    }

    public long failures() {
        return this.val.failures();
    }

    public long minimumTime() {
        return this.val.minTime();
    }

    public long maximumTime() {
        return this.val.maxTime();
    }

    public long lastStartTime() {
        return this.val.lastStartTime();
    }

    @Nullable
    public ConcurrentLinkedDeque8.Node<QueryHistory> link() {
        return this.linkRef.get();
    }

    public boolean replaceLink(ConcurrentLinkedDeque8.Node<QueryHistory> expLink, ConcurrentLinkedDeque8.Node<QueryHistory> updatedLink) {
        return this.linkRef.compareAndSet(expLink, updatedLink);
    }

    public String toString() {
        return S.toString(QueryHistory.class, this);
    }
}

