/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.offheap;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.offheap.GridOffHeapEvictListener;
import org.apache.ignite.internal.util.offheap.GridOffHeapMapFactory;
import org.apache.ignite.internal.util.offheap.GridOffHeapPartitionedMap;
import org.apache.ignite.internal.util.typedef.CX2;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.marshaller.Marshaller;
import org.jetbrains.annotations.Nullable;

public class GridOffHeapProcessor
extends GridProcessorAdapter {
    private final ConcurrentHashMap<String, GridOffHeapPartitionedMap> offheap = new ConcurrentHashMap();
    private final Marshaller marsh;

    public GridOffHeapProcessor(GridKernalContext ctx) {
        super(ctx);
        this.marsh = ctx.config().getMarshaller();
    }

    public void create(@Nullable String spaceName, int parts, long init, long max, @Nullable GridOffHeapEvictListener lsnr) {
        GridOffHeapPartitionedMap m4;
        GridOffHeapPartitionedMap old = this.offheap.put(spaceName = this.maskNull(spaceName), m4 = GridOffHeapMapFactory.unsafePartitionedMap(parts, 1024, 0.75f, init, max, (short)512, lsnr));
        if (old != null) {
            old.destruct();
        }
    }

    public void destruct(@Nullable String spaceName) {
        GridOffHeapPartitionedMap map = this.offheap.remove(spaceName = this.maskNull(spaceName));
        if (map != null) {
            map.destruct();
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        super.stop(cancel);
        for (GridOffHeapPartitionedMap m4 : this.offheap.values()) {
            m4.destruct();
        }
    }

    @Nullable
    private GridOffHeapPartitionedMap offheap(@Nullable String spaceName) {
        return this.offheap.get(this.maskNull(spaceName));
    }

    private byte[] keyBytes(KeyCacheObject key, @Nullable byte[] keyBytes) throws IgniteCheckedException {
        assert (key != null);
        return keyBytes != null ? keyBytes : U.marshal(this.marsh, (Object)key);
    }

    private String maskNull(@Nullable String spaceName) {
        if (spaceName == null) {
            return "gg-dflt-offheap-swap";
        }
        return spaceName;
    }

    public boolean contains(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes) throws IgniteCheckedException {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 != null && m4.contains(part, U.hash(key), this.keyBytes(key, keyBytes));
    }

    @Nullable
    public byte[] get(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes) throws IgniteCheckedException {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? null : m4.get(part, U.hash(key), this.keyBytes(key, keyBytes));
    }

    @Nullable
    public IgniteBiTuple<Long, Integer> valuePointer(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes) throws IgniteCheckedException {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? null : m4.valuePointer(part, U.hash(key), this.keyBytes(key, keyBytes));
    }

    public void enableEviction(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes) throws IgniteCheckedException {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        if (m4 != null) {
            m4.enableEviction(part, U.hash(key), this.keyBytes(key, keyBytes));
        }
    }

    @Nullable
    public <T> T getValue(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        byte[] valBytes = this.get(spaceName, part, key, keyBytes);
        if (valBytes == null) {
            return null;
        }
        return U.unmarshal(this.marsh, valBytes, U.resolveClassLoader(ldr, this.ctx.config()));
    }

    @Nullable
    public byte[] remove(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes) throws IgniteCheckedException {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        if (this.log.isTraceEnabled()) {
            this.log.trace("offheap remove [key=" + key + ']');
        }
        return m4 == null ? null : m4.remove(part, U.hash(key), this.keyBytes(key, keyBytes));
    }

    public void put(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes, byte[] valBytes) throws IgniteCheckedException {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        if (m4 == null) {
            throw new IgniteCheckedException("Failed to write data to off-heap space, no space registered for name: " + spaceName);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("offheap put [key=" + key + ']');
        }
        m4.put(part, U.hash(key), this.keyBytes(key, keyBytes), valBytes);
    }

    public boolean removex(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes) throws IgniteCheckedException {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        if (this.log.isTraceEnabled()) {
            this.log.trace("offheap removex [key=" + key + ']');
        }
        return m4 != null && m4.removex(part, U.hash(key), this.keyBytes(key, keyBytes));
    }

    public boolean removex(@Nullable String spaceName, int part, KeyCacheObject key, byte[] keyBytes, IgniteBiPredicate<Long, Integer> p) throws IgniteCheckedException {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        if (this.log.isTraceEnabled()) {
            this.log.trace("offheap removex [key=" + key + ']');
        }
        return m4 != null && m4.removex(part, U.hash(key), this.keyBytes(key, keyBytes), p);
    }

    public GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> iterator(@Nullable String spaceName) {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? new GridEmptyCloseableIterator() : m4.iterator();
    }

    public <T> GridCloseableIterator<T> iterator(@Nullable String spaceName, CX2<T2<Long, Integer>, T2<Long, Integer>, T> c) {
        assert (c != null);
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? new GridEmptyCloseableIterator() : m4.iterator(c);
    }

    public <T> GridCloseableIterator<T> iterator(@Nullable String spaceName, CX2<T2<Long, Integer>, T2<Long, Integer>, T> c, int part) {
        assert (c != null);
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? new GridEmptyCloseableIterator() : m4.iterator(c, part);
    }

    public long entriesCount(@Nullable String spaceName) {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? -1L : m4.size();
    }

    public long entriesCount(@Nullable String spaceName, Set<Integer> parts) {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? -1L : m4.size(parts);
    }

    public long allocatedSize(@Nullable String spaceName) {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? -1L : m4.allocatedSize();
    }

    public GridCloseableIterator<IgniteBiTuple<byte[], byte[]>> iterator(@Nullable String spaceName, int part) {
        GridOffHeapPartitionedMap m4 = this.offheap(spaceName);
        return m4 == null ? new GridEmptyCloseableIterator() : m4.iterator(part);
    }
}

