/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.NoMatchingCachesException;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VerifyBackupPartitionsDumpTask
extends ComputeTaskAdapter<VisorIdleVerifyTaskArg, String> {
    private static final long serialVersionUID = 0L;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss_SSS");
    public static final String IDLE_DUMP_FILE_PREFIX = "idle-dump-";
    private final VerifyBackupPartitionsTaskV2 delegate = new VerifyBackupPartitionsTaskV2();
    private VisorIdleVerifyDumpTaskArg taskArg;
    @IgniteInstanceResource
    private Ignite ignite;
    @LoggerResource
    private IgniteLogger log;

    @Override
    @NotNull
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, VisorIdleVerifyTaskArg arg) throws IgniteException {
        if (arg instanceof VisorIdleVerifyDumpTaskArg) {
            this.taskArg = (VisorIdleVerifyDumpTaskArg)arg;
        }
        return this.delegate.map(subgrid, arg);
    }

    @Override
    @Nullable
    public String reduce(List<ComputeJobResult> results) throws IgniteException {
        TreeMap<PartitionKeyV2, List> clusterHashes = new TreeMap<PartitionKeyV2, List>(this.buildPartitionKeyComparator());
        for (ComputeJobResult res : results) {
            if (res.getException() != null) continue;
            Map nodeHashes = (Map)res.getData();
            for (Map.Entry e : nodeHashes.entrySet()) {
                clusterHashes.computeIfAbsent((PartitionKeyV2)e.getKey(), k -> new ArrayList()).add(e.getValue());
            }
        }
        Comparator<PartitionHashRecordV2> recordComp = this.buildRecordComparator().reversed();
        LinkedHashMap<PartitionKeyV2, List<PartitionHashRecordV2>> partitions = new LinkedHashMap<PartitionKeyV2, List<PartitionHashRecordV2>>();
        int skippedRecords = 0;
        for (Map.Entry entry : clusterHashes.entrySet()) {
            if (this.needToAdd((List)entry.getValue())) {
                ((List)entry.getValue()).sort(recordComp);
                partitions.put((PartitionKeyV2)entry.getKey(), (List<PartitionHashRecordV2>)entry.getValue());
                continue;
            }
            ++skippedRecords;
        }
        return this.writeHashes(partitions, (IdleVerifyResultV2)this.delegate.reduce((List)results), skippedRecords);
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        return this.delegate.result(res, rcvd);
    }

    private boolean needToAdd(List<PartitionHashRecordV2> records) {
        if (records.isEmpty() || this.taskArg != null && !this.taskArg.skipZeros()) {
            return true;
        }
        PartitionHashRecordV2 record = records.get(0);
        if (record.size() != 0L) {
            return true;
        }
        int firstHash = record.partitionHash();
        int firstVerHash = record.partitionVersionsHash();
        for (int i = 1; i < records.size(); ++i) {
            record = records.get(i);
            if (record.partitionHash() == firstHash && record.partitionVersionsHash() == firstVerHash && record.size() == 0L) continue;
            return true;
        }
        return false;
    }

    private String writeHashes(Map<PartitionKeyV2, List<PartitionHashRecordV2>> partitions, IdleVerifyResultV2 conflictRes, int skippedRecords) throws IgniteException {
        String wd = this.ignite.configuration().getWorkDirectory();
        File workDir = wd == null ? new File("/tmp") : new File(wd);
        File out = new File(workDir, IDLE_DUMP_FILE_PREFIX + LocalDateTime.now().format(TIME_FORMATTER) + ".txt");
        if (this.ignite.log().isInfoEnabled()) {
            this.ignite.log().info("IdleVerifyDumpTask will write output to " + out.getAbsolutePath());
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(out));){
            this.writeResult(partitions, conflictRes, skippedRecords, writer);
            writer.flush();
            if (this.ignite.log().isInfoEnabled()) {
                this.ignite.log().info("IdleVerifyDumpTask successfully written dump to '" + out.getAbsolutePath() + "'");
            }
        }
        catch (IOException | IgniteException e) {
            this.ignite.log().error("Failed to write dump file: " + out.getAbsolutePath(), e);
            throw new IgniteException(e);
        }
        return out.getAbsolutePath();
    }

    private void writeResult(Map<PartitionKeyV2, List<PartitionHashRecordV2>> partitions, IdleVerifyResultV2 conflictRes, int skippedRecords, PrintWriter writer) {
        Map<ClusterNode, Exception> exceptions = conflictRes.exceptions();
        if (!F.isEmpty(exceptions)) {
            boolean noMatchingCaches = false;
            for (Exception e : exceptions.values()) {
                if (!(e instanceof NoMatchingCachesException)) continue;
                noMatchingCaches = true;
                break;
            }
            int size = exceptions.size();
            writer.write("The check procedure failed on " + size + " node" + (size == 1 ? "" : "s") + ".\n");
            if (noMatchingCaches) {
                writer.write("There are no caches matching given filter options.");
            }
        }
        if (!partitions.isEmpty()) {
            writer.write("The check procedure has finished, found " + partitions.size() + " partitions\n");
        }
        VerifyBackupPartitionsDumpTask.logParsedArgs(this.taskArg, writer::write);
        if (skippedRecords > 0) {
            writer.write(skippedRecords + " partitions was skipped\n");
        }
        if (!F.isEmpty(partitions)) {
            writer.write("Cluster partitions:\n");
            for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : partitions.entrySet()) {
                writer.write("Partition: " + entry.getKey() + "\n");
                writer.write("Partition instances: " + entry.getValue() + "\n");
            }
            writer.write("\n\n-----------------------------------\n\n");
            conflictRes.print(writer::write, true);
        }
    }

    private Comparator<PartitionHashRecordV2> buildRecordComparator() {
        return (o1, o2) -> {
            int compare = Boolean.compare(o1.isPrimary(), o2.isPrimary());
            if (compare != 0) {
                return compare;
            }
            return o1.consistentId().toString().compareTo(o2.consistentId().toString());
        };
    }

    private Comparator<PartitionKeyV2> buildPartitionKeyComparator() {
        return (o1, o2) -> {
            int compare = Integer.compare(o1.groupId(), o2.groupId());
            if (compare != 0) {
                return compare;
            }
            return Integer.compare(o1.partitionId(), o2.partitionId());
        };
    }

    public static void logParsedArgs(VisorIdleVerifyTaskArg args, Consumer<String> logConsumer) {
        SB options = new SB("The check procedure task was executed with the following args: ");
        options.a("caches=[").a(args.caches() == null ? "" : String.join((CharSequence)", ", args.caches())).a("], excluded=[").a(args.excludeCaches() == null ? "" : String.join((CharSequence)", ", args.excludeCaches())).a("]").a(", cacheFilter=[").a(args.cacheFilterEnum().toString()).a("]\n");
        logConsumer.accept(options.toString());
    }
}

