/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.query.ContinuousQueryWithTransformer;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.CacheQueryReadEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.P2PClassLoadingIssues;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryAcknowledgeBuffer;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryBatchAck;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryDeployableObject;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEntry;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEvent;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEventBuffer;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryListener;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryManager;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryPartitionRecovery;
import org.apache.ignite.internal.processors.cache.query.continuous.CounterSkipContext;
import org.apache.ignite.internal.processors.continuous.GridContinuousBatch;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.processors.continuous.GridContinuousQueryBatch;
import org.apache.ignite.internal.processors.platform.cache.query.PlatformContinuousQueryFilter;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteAsyncCallback;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheContinuousQueryHandler<K, V>
implements GridContinuousHandler {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_CONTINUOUS_QUERY_BACKUP_ACK_THRESHOLD = 100;
    public static final int DFLT_CONTINUOUS_QUERY_LISTENER_MAX_BUFFER_SIZE = 10000;
    @SystemProperty(value="The size of the buffer with acknowledgment events that are sent to backup nodes", type=Long.class, defaults="100")
    public static final String IGNITE_CONTINUOUS_QUERY_BACKUP_ACK_THRESHOLD = "IGNITE_CONTINUOUS_QUERY_BACKUP_ACK_THRESHOLD";
    @SystemProperty(value="The maximum size of the continuous query listener buffer. 10% of events are dropped once the buffer is full", type=Long.class, defaults="10000")
    public static final String IGNITE_CONTINUOUS_QUERY_LISTENER_MAX_BUFFER_SIZE = "IGNITE_CONTINUOUS_QUERY_LISTENER_MAX_BUFFER_SIZE";
    static final int BACKUP_ACK_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_CONTINUOUS_QUERY_BACKUP_ACK_THRESHOLD", 100);
    static final int LSNR_MAX_BUF_SIZE = IgniteSystemProperties.getInteger("IGNITE_CONTINUOUS_QUERY_LISTENER_MAX_BUFFER_SIZE", 10000);
    private transient IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> returnValTrans = new IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, Object>(){

        @Override
        public Object apply(CacheEntryEvent<? extends K, ? extends V> evt) {
            assert (evt.getKey() == null);
            return evt.getValue();
        }
    };
    private String cacheName;
    private Object topic;
    protected transient IgniteInternalFuture<Void> p2pUnmarshalFut = new GridFinishedFuture<Void>();
    protected transient IgniteInternalFuture<Void> initFut;
    private transient CacheEntryUpdatedListener<K, V> locLsnr;
    private CacheEntryEventSerializableFilter<K, V> rmtFilter;
    private CacheContinuousQueryDeployableObject rmtFilterDep;
    private boolean internal;
    private boolean notifyExisting;
    private boolean oldValRequired;
    private boolean sync;
    private boolean ignoreExpired;
    private int taskHash;
    private transient boolean skipPrimaryCheck;
    private transient boolean locOnly;
    private boolean keepBinary;
    private transient ConcurrentMap<Integer, CacheContinuousQueryPartitionRecovery> rcvs;
    private transient ConcurrentMap<Integer, CacheContinuousQueryEventBuffer> entryBufs;
    private transient CacheContinuousQueryAcknowledgeBuffer ackBuf;
    private transient int cacheId;
    private volatile transient Map<Integer, T2<Long, Long>> initUpdCntrs;
    private volatile transient Map<UUID, Map<Integer, T2<Long, Long>>> initUpdCntrsPerNode;
    private volatile transient AffinityTopologyVersion initTopVer;
    private volatile transient boolean nodeLeft;
    private transient boolean ignoreClsNotFound;
    transient boolean asyncCb;
    private transient UUID nodeId;
    private transient UUID routineId;
    private volatile transient Map<Integer, T2<Long, Long>> locInitUpdCntrs;
    private transient GridKernalContext ctx;
    private transient IgniteLogger log;

    public CacheContinuousQueryHandler() {
    }

    public CacheContinuousQueryHandler(String cacheName, Object topic, @Nullable CacheEntryUpdatedListener<K, V> locLsnr, @Nullable CacheEntryEventSerializableFilter<K, V> rmtFilter, boolean oldValRequired, boolean sync, boolean ignoreExpired, boolean ignoreClsNotFound) {
        assert (topic != null);
        this.cacheName = cacheName;
        this.topic = topic;
        this.locLsnr = locLsnr;
        this.rmtFilter = rmtFilter;
        this.oldValRequired = oldValRequired;
        this.sync = sync;
        this.ignoreExpired = ignoreExpired;
        this.ignoreClsNotFound = ignoreClsNotFound;
        this.cacheId = CU.cacheId(cacheName);
    }

    public void internal(boolean internal) {
        this.internal = internal;
    }

    public void notifyExisting(boolean notifyExisting) {
        this.notifyExisting = notifyExisting;
    }

    public boolean notifyExisting() {
        return this.notifyExisting;
    }

    public boolean oldValueRequired() {
        return this.oldValRequired;
    }

    public CacheEntryUpdatedListener<K, V> localListener() {
        return this.locLsnr;
    }

    public void localOnly(boolean locOnly) {
        this.locOnly = locOnly;
    }

    public boolean localOnly() {
        return this.locOnly;
    }

    public void taskNameHash(int taskHash) {
        this.taskHash = taskHash;
    }

    public void skipPrimaryCheck(boolean skipPrimaryCheck) {
        this.skipPrimaryCheck = skipPrimaryCheck;
    }

    @Override
    public boolean isEvents() {
        return false;
    }

    @Override
    public boolean isMessaging() {
        return false;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean keepBinary() {
        return this.keepBinary;
    }

    public void keepBinary(boolean keepBinary) {
        this.keepBinary = keepBinary;
    }

    @Override
    public String cacheName() {
        return this.cacheName;
    }

    @Override
    public void updateCounters(AffinityTopologyVersion topVer, Map<UUID, Map<Integer, T2<Long, Long>>> cntrsPerNode, Map<Integer, T2<Long, Long>> cntrs) {
        this.initUpdCntrsPerNode = cntrsPerNode;
        this.initUpdCntrs = cntrs;
        this.initTopVer = topVer;
    }

    @Override
    public Map<Integer, T2<Long, Long>> updateCounters() {
        return this.locInitUpdCntrs;
    }

    @Override
    public GridContinuousHandler.RegisterStatus register(final UUID nodeId, final UUID routineId, final GridKernalContext ctx) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (routineId != null);
        assert (ctx != null);
        this.initLocalListener(this.locLsnr, ctx);
        if (this.initFut == null) {
            this.initFut = this.p2pUnmarshalFut.chain(fut -> {
                try {
                    fut.get();
                    this.initRemoteFilter(this.getEventFilter0(), ctx);
                    IgniteClosure<CacheEntryEvent<K, V>, ?> trans = this.getTransformer0();
                    if (trans != null) {
                        ctx.resource().injectGeneric(trans);
                    }
                }
                catch (ExceptionInInitializerError | IgniteCheckedException e) {
                    throw new IgniteException("Failed to initialize a continuous query.", e);
                }
                return null;
            });
        }
        if (this.initFut.error() != null) {
            throw new IgniteCheckedException("Failed to initialize a continuous query.", this.initFut.error());
        }
        this.entryBufs = new ConcurrentHashMap<Integer, CacheContinuousQueryEventBuffer>();
        this.ackBuf = new CacheContinuousQueryAcknowledgeBuffer();
        this.rcvs = new ConcurrentHashMap<Integer, CacheContinuousQueryPartitionRecovery>();
        this.nodeId = nodeId;
        this.routineId = routineId;
        this.ctx = ctx;
        final boolean loc = nodeId.equals(ctx.localNodeId());
        assert (!this.skipPrimaryCheck || loc);
        this.log = ctx.log("org.apache.ignite.continuous.query");
        CacheContinuousQueryListener lsnr = new CacheContinuousQueryListener<K, V>(){

            @Override
            public void onBeforeRegister() {
                GridCacheContext cctx = CacheContinuousQueryHandler.this.cacheContext(ctx);
                if (cctx != null) {
                    cctx.topology().readLock();
                }
            }

            @Override
            public void onAfterRegister() {
                GridCacheContext cctx = CacheContinuousQueryHandler.this.cacheContext(ctx);
                if (cctx != null) {
                    cctx.topology().readUnlock();
                }
            }

            @Override
            public void onRegister() {
                GridCacheContext cctx = CacheContinuousQueryHandler.this.cacheContext(ctx);
                if (cctx != null) {
                    CacheContinuousQueryHandler.this.locInitUpdCntrs = CachePartitionPartialCountersMap.toCountersMap(cctx.topology().localUpdateCounters(false));
                }
            }

            @Override
            public boolean keepBinary() {
                return CacheContinuousQueryHandler.this.keepBinary;
            }

            @Override
            public void onEntryUpdated(CacheContinuousQueryEvent<K, V> evt, boolean primary, boolean recordIgniteEvt, GridDhtAtomicAbstractUpdateFuture fut) {
                GridCacheContext cctx;
                if (CacheContinuousQueryHandler.this.ignoreExpired && evt.getEventType() == EventType.EXPIRED) {
                    return;
                }
                if (CacheContinuousQueryHandler.this.log.isDebugEnabled()) {
                    CacheContinuousQueryHandler.this.log.debug("Entry updated on affinity node [evt=" + evt + ", primary=" + primary + ']');
                }
                if ((cctx = CacheContinuousQueryHandler.this.cacheContext(ctx)) == null) {
                    return;
                }
                if (!this.needNotify(false, cctx, -1, -1L, evt)) {
                    return;
                }
                assert (!CacheContinuousQueryHandler.this.skipPrimaryCheck || cctx.isReplicated() && ctx.localNodeId().equals(nodeId));
                if (CacheContinuousQueryHandler.this.asyncCb) {
                    ContinuousQueryAsyncClosure clsr = new ContinuousQueryAsyncClosure(primary, evt, recordIgniteEvt, fut);
                    ctx.pools().asyncCallbackPool().execute(clsr, evt.partitionId());
                } else {
                    boolean notify = CacheContinuousQueryHandler.this.filter(evt);
                    if (CacheContinuousQueryHandler.this.log.isDebugEnabled()) {
                        CacheContinuousQueryHandler.this.log.debug("Filter invoked for event [evt=" + evt + ", primary=" + primary + ", notify=" + notify + ']');
                    }
                    if (primary || CacheContinuousQueryHandler.this.skipPrimaryCheck) {
                        CacheContinuousQueryHandler.this.onEntryUpdate(evt, notify, loc, recordIgniteEvt);
                    } else {
                        CacheContinuousQueryHandler.this.handleBackupEntry(cctx, evt.entry());
                    }
                }
            }

            @Override
            public void onUnregister() {
                block3: {
                    try {
                        CacheEntryEventFilter filter = CacheContinuousQueryHandler.this.getEventFilter();
                        if (filter instanceof PlatformContinuousQueryFilter) {
                            ((PlatformContinuousQueryFilter)filter).onQueryUnregister();
                        }
                    }
                    catch (IgniteCheckedException e) {
                        if (!CacheContinuousQueryHandler.this.log.isDebugEnabled()) break block3;
                        CacheContinuousQueryHandler.this.log.debug("Failed to execute the onUnregister callback on the continuoue query listener. [nodeId=" + nodeId + ", routineId=" + routineId + ", cacheName=" + CacheContinuousQueryHandler.this.cacheName + ", err=" + e + "]");
                    }
                }
            }

            @Override
            public void cleanupOnAck(Map<Integer, Long> updateCntrs) {
                for (Map.Entry<Integer, Long> e : updateCntrs.entrySet()) {
                    CacheContinuousQueryEventBuffer buf = (CacheContinuousQueryEventBuffer)CacheContinuousQueryHandler.this.entryBufs.get(e.getKey());
                    if (buf == null) continue;
                    buf.cleanupOnAck(e.getValue());
                }
            }

            @Override
            public void flushOnExchangeDone(GridKernalContext ctx2, AffinityTopologyVersion topVer) {
                assert (topVer != null);
                try {
                    GridCacheContext cctx = CacheContinuousQueryHandler.this.cacheContext(ctx2);
                    ClusterNode node = ctx2.discovery().node(nodeId);
                    for (Map.Entry bufE : CacheContinuousQueryHandler.this.entryBufs.entrySet()) {
                        CacheContinuousQueryEventBuffer buf = (CacheContinuousQueryEventBuffer)bufE.getValue();
                        Collection<CacheContinuousQueryEntry> entries = buf.flushOnExchange((cntr, filtered) -> CacheContinuousQueryEntry.createFilteredEntry(cctx.cacheId(), (Integer)bufE.getKey(), topVer, cntr, filtered));
                        if (entries == null || node == null) continue;
                        for (CacheContinuousQueryEntry e : entries) {
                            e.markBackup();
                            if (e.isFiltered()) continue;
                            CacheContinuousQueryHandler.this.prepareEntry(cctx, nodeId, e);
                        }
                        ctx2.continuous().addBackupNotification(nodeId, routineId, entries, CacheContinuousQueryHandler.this.topic);
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(ctx2.log("org.apache.ignite.continuous.query"), "Failed to send backup event notification to node: " + nodeId, e);
                }
            }

            @Override
            public void acknowledgeBackupOnTimeout(GridKernalContext ctx2) {
                CacheContinuousQueryHandler.this.sendBackupAcknowledge(CacheContinuousQueryHandler.this.ackBuf.acknowledgeOnTimeout(), routineId, ctx2);
            }

            @Override
            public void skipUpdateEvent(CacheContinuousQueryEvent<K, V> evt, AffinityTopologyVersion topVer, boolean primary) {
                assert (evt != null);
                CacheContinuousQueryEntry e = evt.entry();
                e.markFiltered();
                this.onEntryUpdated(evt, primary, false, null);
            }

            @Override
            public CounterSkipContext skipUpdateCounter(GridCacheContext cctx, @Nullable CounterSkipContext skipCtx, int part, long cntr, AffinityTopologyVersion topVer, boolean primary) {
                if (skipCtx == null) {
                    skipCtx = new CounterSkipContext(part, cntr, topVer);
                }
                if (!this.needNotify(true, cctx, part, cntr, null)) {
                    return skipCtx;
                }
                if (loc) {
                    assert (!CacheContinuousQueryHandler.this.locOnly);
                    final Collection evts = CacheContinuousQueryHandler.this.handleEvent(ctx, skipCtx.entry());
                    if (!evts.isEmpty()) {
                        if (CacheContinuousQueryHandler.this.asyncCb) {
                            ctx.pools().asyncCallbackPool().execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        CacheContinuousQueryHandler.this.notifyLocalListener(evts, CacheContinuousQueryHandler.this.getTransformer());
                                    }
                                    catch (IgniteCheckedException ex) {
                                        U.error(ctx.log("org.apache.ignite.continuous.query"), "Failed to notify local listener.", ex);
                                    }
                                }
                            }, part);
                        } else {
                            skipCtx.addProcessClosure(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        CacheContinuousQueryHandler.this.notifyLocalListener(evts, CacheContinuousQueryHandler.this.getTransformer());
                                    }
                                    catch (IgniteCheckedException ex) {
                                        U.error(ctx.log("org.apache.ignite.continuous.query"), "Failed to notify local listener.", ex);
                                    }
                                }
                            });
                        }
                    }
                    return skipCtx;
                }
                CacheContinuousQueryEventBuffer buf = CacheContinuousQueryHandler.this.partitionBuffer(cctx, part);
                final Object entryOrList = buf.processEntry(skipCtx.entry(), !primary);
                if (entryOrList != null) {
                    skipCtx.addProcessClosure(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ctx.continuous().addNotification(nodeId, routineId, entryOrList, CacheContinuousQueryHandler.this.topic, false, true);
                            }
                            catch (ClusterTopologyCheckedException ex) {
                                if (CacheContinuousQueryHandler.this.log.isDebugEnabled()) {
                                    CacheContinuousQueryHandler.this.log.debug("Failed to send event notification to node, node left cluster [node=" + nodeId + ", err=" + ex + ']');
                                }
                            }
                            catch (IgniteCheckedException ex) {
                                U.error(ctx.log("org.apache.ignite.continuous.query"), "Failed to send event notification to node: " + nodeId, ex);
                            }
                        }
                    });
                }
                return skipCtx;
            }

            @Override
            public void onPartitionEvicted(int part) {
                CacheContinuousQueryHandler.this.entryBufs.remove(part);
            }

            @Override
            public boolean oldValueRequired() {
                return CacheContinuousQueryHandler.this.oldValRequired;
            }

            @Override
            public boolean notifyExisting() {
                return CacheContinuousQueryHandler.this.notifyExisting;
            }

            private String taskName() {
                return ctx.security().enabled() ? ctx.task().resolveTaskName(CacheContinuousQueryHandler.this.taskHash) : null;
            }

            @Override
            public boolean isPrimaryOnly() {
                return CacheContinuousQueryHandler.this.locOnly && !CacheContinuousQueryHandler.this.skipPrimaryCheck;
            }

            private boolean needNotify(boolean skipEvt, GridCacheContext cctx, int part, long cntr, CacheContinuousQueryEvent evt) {
                assert (!skipEvt || evt == null);
                assert (skipEvt || part == -1 && cntr == -1L);
                if (!cctx.mvccEnabled()) {
                    return true;
                }
                assert (CacheContinuousQueryHandler.this.locInitUpdCntrs != null);
                cntr = skipEvt ? cntr : evt.getPartitionUpdateCounter();
                part = skipEvt ? part : evt.partitionId();
                T2 initCntr = (T2)CacheContinuousQueryHandler.this.locInitUpdCntrs.get(part);
                return initCntr == null || cntr >= (Long)initCntr.get2();
            }
        };
        CacheContinuousQueryManager mgr = this.manager(ctx);
        if (mgr == null) {
            return GridContinuousHandler.RegisterStatus.DELAYED;
        }
        GridContinuousHandler.RegisterStatus regStatus = mgr.registerListener(routineId, lsnr, this.internal);
        if (regStatus == GridContinuousHandler.RegisterStatus.REGISTERED) {
            this.initFut.listen(res -> this.sendQueryExecutedEvent());
        }
        return regStatus;
    }

    private void sendQueryExecutedEvent() {
        CacheEntryEventFilter filter;
        GridCacheContext<K, V> cctx = this.cacheContext(this.ctx);
        try {
            filter = this.getEventFilter();
        }
        catch (IgniteCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to trigger the continuoue query executed event. [routineId=" + this.routineId + ", cacheName=" + this.cacheName + ", err=" + e + "]");
            }
            return;
        }
        if (cctx != null && cctx.events().isRecordable(96)) {
            this.ctx.event().record(new CacheQueryExecutedEvent(this.ctx.discovery().localNode(), "Continuous query executed.", 96, CacheQueryType.CONTINUOUS.name(), this.cacheName, null, null, null, filter instanceof CacheEntryEventSerializableFilter ? (CacheEntryEventSerializableFilter)filter : null, null, this.nodeId, this.taskName()));
        }
    }

    private void initLocalListener(CacheEntryListener lsnr, GridKernalContext ctx) throws IgniteCheckedException {
        if (lsnr != null) {
            CacheEntryListener impl2 = lsnr instanceof CacheContinuousQueryManager.JCacheQueryLocalListener ? ((CacheContinuousQueryManager.JCacheQueryLocalListener)lsnr).impl : lsnr;
            ctx.resource().injectGeneric(impl2);
            this.asyncCb = U.hasAnnotation(impl2, IgniteAsyncCallback.class);
        }
    }

    protected void initRemoteFilter(CacheEntryEventFilter filter, GridKernalContext ctx) throws IgniteCheckedException {
        CacheEntryEventFilter impl2;
        CacheEntryEventFilter cacheEntryEventFilter = impl2 = filter instanceof CacheContinuousQueryManager.JCacheQueryRemoteFilter ? ((CacheContinuousQueryManager.JCacheQueryRemoteFilter)filter).impl : filter;
        if (impl2 != null) {
            ctx.resource().injectGeneric(impl2);
            if (!this.asyncCb) {
                this.asyncCb = U.hasAnnotation(impl2, IgniteAsyncCallback.class);
            }
        }
    }

    public CacheEntryEventFilter getEventFilter() throws IgniteCheckedException {
        this.initFut.get();
        return this.getEventFilter0();
    }

    protected CacheEntryEventFilter getEventFilter0() {
        return this.rmtFilter;
    }

    @Nullable
    public IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> getTransformer() throws IgniteCheckedException {
        this.initFut.get();
        return this.getTransformer0();
    }

    public IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> getTransformer0() {
        return null;
    }

    @Nullable
    public ContinuousQueryWithTransformer.EventListener<?> localTransformedEventListener() {
        return null;
    }

    private void prepareEntry(GridCacheContext cctx, UUID nodeId, CacheContinuousQueryEntry entry) throws IgniteCheckedException {
        if (cctx.kernalContext().config().isPeerClassLoadingEnabled() && cctx.discovery().node(nodeId) != null) {
            entry.prepareMarshal(cctx);
            cctx.deploy().prepare(entry);
        } else {
            entry.prepareMarshal(cctx);
        }
    }

    void waitTopologyFuture(GridKernalContext ctx) throws IgniteCheckedException {
        GridCacheContext<K, V> cctx = this.cacheContext(ctx);
        AffinityTopologyVersion topVer = this.initTopVer;
        this.cacheContext(ctx).shared().exchange().affinityReadyFuture(topVer).get();
        for (int partId = 0; partId < this.cacheContext(ctx).affinity().partitions(); ++partId) {
            this.getOrCreatePartitionRecovery(ctx, partId, topVer);
        }
    }

    @Override
    public void unregister(UUID routineId, GridKernalContext ctx) {
        assert (routineId != null);
        assert (ctx != null);
        GridCacheAdapter cache = ctx.cache().internalCache(this.cacheName);
        if (cache != null) {
            cache.context().continuousQueries().unregisterListener(this.internal, routineId);
        }
    }

    private CacheContinuousQueryManager manager(GridKernalContext ctx) {
        GridCacheContext<K, V> cacheCtx = this.cacheContext(ctx);
        return cacheCtx == null ? null : cacheCtx.continuousQueries();
    }

    @Override
    public void notifyCallback(final UUID nodeId, UUID routineId, Collection<?> objs, final GridKernalContext ctx) {
        assert (nodeId != null);
        assert (routineId != null);
        assert (objs != null);
        assert (ctx != null);
        if (objs.isEmpty()) {
            return;
        }
        if (this.asyncCb) {
            final List<Object> entries = objs instanceof List ? (List<Object>)objs : new ArrayList<CacheContinuousQueryEntry>(objs);
            IgniteStripedThreadPoolExecutor asyncPool = ctx.pools().asyncCallbackPool();
            int threadId = asyncPool.threadId(((CacheContinuousQueryEntry)entries.get(0)).partition());
            int startIdx = 0;
            if (entries.size() != 1) {
                for (int i = 1; i < entries.size(); ++i) {
                    int curThreadId = asyncPool.threadId(((CacheContinuousQueryEntry)entries.get(i)).partition());
                    if (curThreadId == threadId) continue;
                    final int i0 = i;
                    final int startIdx0 = startIdx;
                    asyncPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            CacheContinuousQueryHandler.this.notifyCallback0(nodeId, ctx, entries.subList(startIdx0, i0));
                        }
                    }, threadId);
                    startIdx = i0;
                    threadId = curThreadId;
                }
            }
            final int startIdx0 = startIdx;
            asyncPool.execute(new Runnable(){

                @Override
                public void run() {
                    CacheContinuousQueryHandler.this.notifyCallback0(nodeId, ctx, startIdx0 == 0 ? entries : entries.subList(startIdx0, entries.size()));
                }
            }, threadId);
        } else {
            this.notifyCallback0(nodeId, ctx, objs);
        }
    }

    private void notifyCallback0(UUID nodeId, GridKernalContext ctx, Collection<CacheContinuousQueryEntry> entries) {
        GridCacheContext<K, V> cctx = this.cacheContext(ctx);
        if (cctx == null) {
            IgniteLogger log = ctx.log("org.apache.ignite.continuous.query");
            if (log.isDebugEnabled()) {
                log.debug("Failed to notify callback, cache is not found: " + this.cacheId);
            }
            return;
        }
        ArrayList<CacheEntryEvent<K, V>> entries0 = new ArrayList<CacheEntryEvent<K, V>>(entries.size());
        for (CacheContinuousQueryEntry e : entries) {
            GridCacheDeploymentManager<K, V> depMgr = cctx.deploy();
            ClassLoader ldr = depMgr.globalLoader();
            try {
                GridDeploymentInfo depInfo;
                if (ctx.config().isPeerClassLoadingEnabled() && (depInfo = e.deployInfo()) != null) {
                    depMgr.p2pContext(nodeId, depInfo.classLoaderId(), depInfo.userVersion(), depInfo.deployMode(), depInfo.participants());
                }
                e.unmarshal(cctx, ldr);
                Collection<CacheEntryEvent<K, V>> evts = this.handleEvent(ctx, e);
                if (evts == null || evts.isEmpty()) continue;
                entries0.addAll(evts);
            }
            catch (IgniteCheckedException ex) {
                if (this.ignoreClsNotFound) {
                    assert (this.internal);
                    continue;
                }
                U.error(ctx.log("org.apache.ignite.continuous.query"), "Failed to unmarshal entry.", ex);
            }
        }
        this.notifyLocalListener(entries0, this.returnValTrans);
    }

    private Collection<CacheEntryEvent<? extends K, ? extends V>> handleEvent(GridKernalContext ctx, CacheContinuousQueryEntry e) {
        assert (e != null);
        GridCacheContext<K, V> cctx = this.cacheContext(ctx);
        IgniteCacheProxy cache = ctx.cache().jcache(cctx.name());
        if (this.internal || e.updateCounter() == -1L) {
            return e.isFiltered() ? Collections.emptyList() : F.asList(new CacheContinuousQueryEvent(cache, cctx, e));
        }
        CacheContinuousQueryPartitionRecovery rec = this.getOrCreatePartitionRecovery(ctx, e.partition(), e.topologyVersion());
        return rec.collectEntries(e, cctx, cache);
    }

    public boolean filter(CacheContinuousQueryEvent evt) {
        CacheContinuousQueryEntry entry = evt.entry();
        boolean notify = !entry.isFiltered();
        try {
            if (notify && this.getEventFilter() != null) {
                notify = this.getEventFilter().evaluate(evt);
            }
        }
        catch (NoClassDefFoundError e) {
            P2PClassLoadingIssues.rethrowDisarmedP2PClassLoadingFailure(e);
        }
        catch (Exception e) {
            U.error(this.log, "CacheEntryEventFilter failed: " + e);
        }
        if (!notify) {
            entry.markFiltered();
        }
        return notify;
    }

    private void onEntryUpdate(CacheContinuousQueryEvent<K, V> evt, boolean notify, boolean loc, boolean recordIgniteEvt) {
        try {
            GridCacheContext<K, V> cctx = this.cacheContext(this.ctx);
            if (cctx == null) {
                return;
            }
            CacheContinuousQueryEntry entry = evt.entry();
            IgniteClosure<CacheEntryEvent<K, V>, ?> trans = this.getTransformer();
            if (loc) {
                if (!this.locOnly) {
                    Collection<CacheEntryEvent<? extends K, ? extends V>> evts = this.handleEvent(this.ctx, entry);
                    this.notifyLocalListener(evts, trans);
                    if (!this.internal && !this.skipPrimaryCheck) {
                        this.sendBackupAcknowledge(this.ackBuf.onAcknowledged(entry), this.routineId, this.ctx);
                    }
                } else if (!entry.isFiltered()) {
                    this.notifyLocalListener(F.asList(evt), trans);
                }
            } else {
                Object entryOrList;
                if (!entry.isFiltered()) {
                    if (trans != null) {
                        entry = this.transformToEntry(trans, evt);
                    }
                    this.prepareEntry(cctx, this.nodeId, entry);
                }
                if ((entryOrList = this.handleEntry(cctx, entry)) != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Send the following event to listener: " + entryOrList);
                    }
                    this.ctx.continuous().addNotification(this.nodeId, this.routineId, entryOrList, this.topic, this.sync, true);
                }
            }
        }
        catch (ClusterTopologyCheckedException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send event notification to node, node left cluster [node=" + this.nodeId + ", err=" + ex + ']');
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.ctx.log("org.apache.ignite.continuous.query"), "Failed to send event notification to node: " + this.nodeId, ex);
        }
        if (recordIgniteEvt && notify) {
            CacheEntryEventFilter filter;
            try {
                filter = this.getEventFilter();
            }
            catch (IgniteCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to trigger a continuous query event. [routineId=" + this.routineId + ", cacheName=" + this.cacheName + ", err=" + e + "]");
                }
                return;
            }
            this.ctx.event().record(new CacheQueryReadEvent<K, V>(this.ctx.discovery().localNode(), "Continuous query executed.", 97, CacheQueryType.CONTINUOUS.name(), this.cacheName, null, null, null, filter instanceof CacheEntryEventSerializableFilter ? (CacheEntryEventSerializableFilter)filter : null, null, this.nodeId, this.taskName(), evt.getKey(), evt.getValue(), evt.getOldValue(), null));
        }
    }

    private void notifyLocalListener(Collection<CacheEntryEvent<? extends K, ? extends V>> evts, @Nullable IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> trans) {
        ContinuousQueryWithTransformer.EventListener<?> locTransLsnr = this.localTransformedEventListener();
        assert (this.locLsnr == null || locTransLsnr == null);
        if (F.isEmpty(evts)) {
            return;
        }
        if (this.locLsnr != null) {
            this.locLsnr.onUpdated(evts);
        }
        if (locTransLsnr != null) {
            locTransLsnr.onUpdated(this.transform(trans, evts));
        }
    }

    private String taskName() {
        return this.ctx.security().enabled() ? this.ctx.task().resolveTaskName(this.taskHash) : null;
    }

    @Override
    public void onClientDisconnected() {
        if (this.internal) {
            return;
        }
        for (CacheContinuousQueryPartitionRecovery rec : this.rcvs.values()) {
            rec.resetTopologyCache();
        }
    }

    @NotNull
    private CacheContinuousQueryPartitionRecovery getOrCreatePartitionRecovery(GridKernalContext ctx, int partId, AffinityTopologyVersion topVer) {
        assert (topVer != null && topVer.topologyVersion() > 0L) : topVer;
        CacheContinuousQueryPartitionRecovery rec = (CacheContinuousQueryPartitionRecovery)this.rcvs.get(partId);
        if (rec == null) {
            T2<Long, Long> partCntrs = null;
            Map<UUID, Map<Integer, T2<Long, Long>>> initUpdCntrsPerNode = this.initUpdCntrsPerNode;
            if (initUpdCntrsPerNode != null) {
                GridCacheContext<K, V> cctx = this.cacheContext(ctx);
                GridCacheAffinityManager aff = cctx.affinity();
                for (ClusterNode node : aff.nodesByPartition(partId, topVer)) {
                    Map<Integer, T2<Long, Long>> map = initUpdCntrsPerNode.get(node.id());
                    if (map == null) continue;
                    partCntrs = map.get(partId);
                    break;
                }
            } else if (this.initUpdCntrs != null) {
                partCntrs = this.initUpdCntrs.get(partId);
            }
            rec = new CacheContinuousQueryPartitionRecovery(ctx.log("org.apache.ignite.continuous.query"), topVer, partCntrs != null ? (Long)partCntrs.get2() : null);
            CacheContinuousQueryPartitionRecovery oldRec = this.rcvs.putIfAbsent(partId, rec);
            if (oldRec != null) {
                rec = oldRec;
            }
        }
        return rec;
    }

    private void handleBackupEntry(GridCacheContext cctx, CacheContinuousQueryEntry e) {
        if (this.internal || e.updateCounter() == -1L || this.nodeLeft) {
            return;
        }
        CacheContinuousQueryEventBuffer buf = this.partitionBuffer(cctx, e.partition());
        buf.processEntry(e.copyWithDataReset(), true);
    }

    private Object handleEntry(GridCacheContext cctx, CacheContinuousQueryEntry e) {
        assert (e != null);
        assert (this.entryBufs != null);
        if (this.internal) {
            if (e.isFiltered()) {
                return null;
            }
            return e;
        }
        if (e.updateCounter() == -1L) {
            return e;
        }
        CacheContinuousQueryEventBuffer buf = this.partitionBuffer(cctx, e.partition());
        return buf.processEntry(e, false);
    }

    CacheContinuousQueryEventBuffer partitionBuffer(GridCacheContext<?, ?> cctx, int partId) {
        return this.entryBufs.computeIfAbsent(partId, id -> new CacheContinuousQueryEventBuffer(backup -> {
            GridDhtLocalPartition locPart = cctx.topology().localPartition((int)id, null, false);
            if (locPart == null) {
                return -1L;
            }
            return backup > 0L ? locPart.updateCounter() : locPart.reservedCounter();
        }, this.ctx.log("org.apache.ignite.continuous.query")));
    }

    @Override
    public void flushOnNodeLeft() {
        this.nodeLeft = true;
        for (CacheContinuousQueryEventBuffer buf : this.entryBufs.values()) {
            buf.flushOnExchange(null);
        }
    }

    @Override
    public void p2pMarshal(GridKernalContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        assert (ctx.config().isPeerClassLoadingEnabled());
        if (this.rmtFilter != null && !U.isGrid(this.rmtFilter.getClass())) {
            this.rmtFilterDep = new CacheContinuousQueryDeployableObject(this.rmtFilter, ctx);
        }
    }

    @Override
    public void p2pUnmarshal(UUID nodeId, GridKernalContext ctx) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (ctx != null);
        assert (ctx.config().isPeerClassLoadingEnabled());
        if (this.rmtFilterDep != null) {
            this.rmtFilter = (CacheEntryEventSerializableFilter)this.p2pUnmarshal(this.rmtFilterDep, nodeId, ctx);
        }
        if (!this.p2pUnmarshalFut.isDone()) {
            ((GridFutureAdapter)this.p2pUnmarshalFut).onDone();
        }
    }

    public boolean isMarshalled() {
        return this.rmtFilter == null || U.isGrid(this.rmtFilter.getClass()) || this.rmtFilterDep != null;
    }

    protected <T> T p2pUnmarshal(CacheContinuousQueryDeployableObject depObj, UUID nodeId, GridKernalContext ctx) throws IgniteCheckedException {
        if (depObj != null) {
            try {
                return depObj.unmarshal(nodeId, ctx);
            }
            catch (IgniteCheckedException e) {
                ((GridFutureAdapter)this.p2pUnmarshalFut).onDone(e);
                throw e;
            }
            catch (ExceptionInInitializerError e) {
                IgniteCheckedException err = new IgniteCheckedException("Failed to unmarshal deployable object.", e);
                ((GridFutureAdapter)this.p2pUnmarshalFut).onDone(err);
                throw err;
            }
        }
        return null;
    }

    @Override
    public GridContinuousBatch createBatch() {
        return new GridContinuousQueryBatch();
    }

    @Override
    public void onBatchAcknowledged(UUID routineId, GridContinuousBatch batch, GridKernalContext ctx) {
        this.sendBackupAcknowledge(this.ackBuf.onAcknowledged(batch), routineId, ctx);
    }

    private void sendBackupAcknowledge(final IgniteBiTuple<Map<Integer, Long>, Set<AffinityTopologyVersion>> t2, final UUID routineId, final GridKernalContext ctx) {
        if (t2 != null) {
            ctx.closure().runLocalSafe(new GridPlainRunnable(){

                @Override
                public void run() {
                    GridCacheContext cctx = CacheContinuousQueryHandler.this.cacheContext(ctx);
                    CacheContinuousQueryBatchAck msg = new CacheContinuousQueryBatchAck(cctx.cacheId(), routineId, (Map)t2.get1());
                    for (AffinityTopologyVersion topVer : (Set)t2.get2()) {
                        for (ClusterNode node : ctx.discovery().cacheGroupAffinityNodes(cctx.groupId(), topVer)) {
                            IgniteLogger log;
                            if (node.isLocal()) continue;
                            try {
                                cctx.io().send(node, (GridCacheMessage)msg, (byte)2);
                            }
                            catch (ClusterTopologyCheckedException ignored) {
                                log = ctx.log("org.apache.ignite.continuous.query");
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Failed to send acknowledge message, node left [msg=" + msg + ", node=" + node + ']');
                            }
                            catch (IgniteCheckedException e) {
                                log = ctx.log("org.apache.ignite.continuous.query");
                                U.error(log, "Failed to send acknowledge message [msg=" + msg + ", node=" + node + ']', e);
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    @Nullable
    public Object orderedTopic() {
        return this.topic;
    }

    @Override
    public GridContinuousHandler clone() {
        try {
            return (GridContinuousHandler)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return S.toString(CacheContinuousQueryHandler.class, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.cacheName);
        out.writeObject(this.topic);
        boolean b = this.rmtFilterDep != null;
        out.writeBoolean(b);
        if (b) {
            out.writeObject(this.rmtFilterDep);
        } else {
            out.writeObject(this.rmtFilter);
        }
        out.writeBoolean(this.internal);
        out.writeBoolean(this.notifyExisting);
        out.writeBoolean(this.oldValRequired);
        out.writeBoolean(this.sync);
        out.writeBoolean(this.ignoreExpired);
        out.writeInt(this.taskHash);
        out.writeBoolean(this.keepBinary);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheName = U.readString(in);
        this.topic = in.readObject();
        boolean b = in.readBoolean();
        if (b) {
            this.rmtFilterDep = (CacheContinuousQueryDeployableObject)in.readObject();
            this.p2pUnmarshalFut = new GridFutureAdapter<Void>();
        } else {
            this.rmtFilter = (CacheEntryEventSerializableFilter)in.readObject();
        }
        this.internal = in.readBoolean();
        this.notifyExisting = in.readBoolean();
        this.oldValRequired = in.readBoolean();
        this.sync = in.readBoolean();
        this.ignoreExpired = in.readBoolean();
        this.taskHash = in.readInt();
        this.keepBinary = in.readBoolean();
        this.cacheId = CU.cacheId(this.cacheName);
    }

    private GridCacheContext<K, V> cacheContext(GridKernalContext ctx) {
        assert (ctx != null);
        return ctx.cache().context().cacheContext(this.cacheId);
    }

    private Iterable transform(final IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> trans, Collection<CacheEntryEvent<? extends K, ? extends V>> evts) {
        final Iterator<CacheEntryEvent<? extends K, ? extends V>> iter = evts.iterator();
        return new Iterable(){

            @NotNull
            public Iterator iterator() {
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    public Object next() {
                        return CacheContinuousQueryHandler.this.transform(trans, (CacheEntryEvent)iter.next());
                    }
                };
            }
        };
    }

    private CacheContinuousQueryEntry transformToEntry(IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> trans, CacheContinuousQueryEvent<? extends K, ? extends V> evt) {
        Object transVal = this.transform(trans, evt);
        return new CacheContinuousQueryEntry(evt.entry().cacheId(), evt.entry().eventType(), null, transVal == null ? null : this.cacheContext(this.ctx).toCacheObject(transVal), null, evt.entry().isKeepBinary(), evt.entry().partition(), evt.entry().updateCounter(), evt.entry().topologyVersion(), evt.entry().flags());
    }

    private Object transform(IgniteClosure<CacheEntryEvent<? extends K, ? extends V>, ?> trans, CacheEntryEvent<? extends K, ? extends V> evt) {
        assert (trans != null);
        Object transVal = null;
        try {
            transVal = trans.apply(evt);
        }
        catch (NoClassDefFoundError e) {
            P2PClassLoadingIssues.rethrowDisarmedP2PClassLoadingFailure(e);
        }
        catch (Exception e) {
            U.error(this.log, e);
        }
        return transVal;
    }

    private class ContinuousQueryAsyncClosure
    implements Runnable {
        private final CacheContinuousQueryEvent<K, V> evt;
        private final boolean primary;
        private final boolean recordIgniteEvt;
        private final IgniteInternalFuture<?> fut;

        ContinuousQueryAsyncClosure(boolean primary, CacheContinuousQueryEvent<K, V> evt, boolean recordIgniteEvt, IgniteInternalFuture<?> fut) {
            this.primary = primary;
            this.evt = evt;
            this.recordIgniteEvt = recordIgniteEvt;
            this.fut = fut;
        }

        @Override
        public void run() {
            final boolean notify = CacheContinuousQueryHandler.this.filter(this.evt);
            if (this.primary || CacheContinuousQueryHandler.this.skipPrimaryCheck) {
                if (this.fut == null) {
                    CacheContinuousQueryHandler.this.onEntryUpdate(this.evt, notify, CacheContinuousQueryHandler.this.nodeId.equals(CacheContinuousQueryHandler.this.ctx.localNodeId()), this.recordIgniteEvt);
                    return;
                }
                if (this.fut.isDone()) {
                    if (this.fut.error() != null) {
                        this.evt.entry().markFiltered();
                    }
                    CacheContinuousQueryHandler.this.onEntryUpdate(this.evt, notify, CacheContinuousQueryHandler.this.nodeId.equals(CacheContinuousQueryHandler.this.ctx.localNodeId()), this.recordIgniteEvt);
                } else {
                    this.fut.listen(new CI1<IgniteInternalFuture<?>>(){

                        @Override
                        public void apply(IgniteInternalFuture<?> f) {
                            if (f.error() != null) {
                                ContinuousQueryAsyncClosure.this.evt.entry().markFiltered();
                            }
                            CacheContinuousQueryHandler.this.ctx.pools().asyncCallbackPool().execute(new Runnable(){

                                @Override
                                public void run() {
                                    CacheContinuousQueryHandler.this.onEntryUpdate(ContinuousQueryAsyncClosure.this.evt, notify, CacheContinuousQueryHandler.this.nodeId.equals(CacheContinuousQueryHandler.this.ctx.localNodeId()), ContinuousQueryAsyncClosure.this.recordIgniteEvt);
                                }
                            }, ContinuousQueryAsyncClosure.this.evt.entry().partition());
                        }
                    });
                }
            } else {
                CacheContinuousQueryHandler.this.handleBackupEntry(CacheContinuousQueryHandler.this.cacheContext(CacheContinuousQueryHandler.this.ctx), this.evt.entry());
            }
        }

        public String toString() {
            return S.toString(ContinuousQueryAsyncClosure.class, this);
        }
    }
}

