/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.Base64;
import org.apache.commons.codec.binary.Base64;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class BinaryEncoding
implements TextColumnEncoding {
    private static final Base64.Encoder base64Encoder = java.util.Base64.getEncoder();
    private final Type type;
    private final Slice nullSequence;

    public BinaryEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                Slice slice = this.type.getSlice(block, position);
                byte[] data = slice.getBytes();
                slice = Slices.wrappedBuffer((byte[])base64Encoder.encode(data));
                output.writeBytes(slice);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        Slice slice = this.type.getSlice(block, position);
        byte[] data = slice.getBytes();
        slice = Slices.wrappedBuffer((byte[])base64Encoder.encode(data));
        output.writeBytes(slice);
    }

    @Override
    @SuppressModernizer
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.decodeValue(builder, slice, offset, length);
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.decodeValue(builder, slice, offset, length);
    }

    @SuppressModernizer
    private void decodeValue(BlockBuilder builder, Slice slice, int offset, int length) {
        byte[] data = slice.getBytes(offset, length);
        if (Base64.isBase64((byte[])data)) {
            this.type.writeSlice(builder, Slices.wrappedBuffer((byte[])Base64.decodeBase64((byte[])data)));
        } else {
            this.type.writeSlice(builder, slice, offset, length);
        }
    }
}

