/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.binary;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.encodings.ColumnData;
import io.trino.hive.formats.encodings.EncodeOutput;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public abstract class BlockEncoding
implements BinaryColumnEncoding {
    private final Type type;
    private final DynamicSliceOutput buffer = new DynamicSliceOutput(0);

    public BlockEncoding(Type type) {
        this.type = type;
    }

    @Override
    public final void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                this.encodeValue(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public final void encodeValueInto(Block block, int position, SliceOutput output) {
        this.buffer.reset();
        this.encodeValue(block, position, (SliceOutput)this.buffer);
        Slice slice = this.buffer.slice();
        output.writeInt(Integer.reverseBytes(slice.length()));
        output.writeBytes(slice);
    }

    protected abstract void encodeValue(Block var1, int var2, SliceOutput var3);

    @Override
    public final Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        Slice slice = columnData.getSlice();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length > 0) {
                int offset = columnData.getOffset(i);
                this.decodeValueInto(builder, slice, offset, length);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public final int getValueLength(Slice slice, int offset) {
        return Integer.reverseBytes(slice.getInt(offset));
    }

    @Override
    public final int getValueOffset(Slice slice, int offset) {
        return 4;
    }
}

