/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.DistinctMapKeys;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.encodings.text.BlockEncoding;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;

public class MapEncoding
extends BlockEncoding {
    private final TextColumnEncoding keyEncoding;
    private final TextColumnEncoding valueEncoding;
    private final MapType mapType;
    private final byte elementSeparator;
    private final byte keyValueSeparator;
    private final DistinctMapKeys distinctMapKeys;
    private BlockBuilder keyBlockBuilder;

    public MapEncoding(Type type, Slice nullSequence, byte elementSeparator, byte keyValueSeparator, Byte escapeByte, TextColumnEncoding keyEncoding, TextColumnEncoding valueEncoding) {
        super(type, nullSequence, escapeByte);
        this.mapType = (MapType)type;
        this.elementSeparator = elementSeparator;
        this.keyValueSeparator = keyValueSeparator;
        this.keyEncoding = keyEncoding;
        this.valueEncoding = valueEncoding;
        this.distinctMapKeys = new DistinctMapKeys(this.mapType, false);
        this.keyBlockBuilder = this.mapType.getKeyType().createBlockBuilder(null, 128);
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) throws FileCorruptionException {
        Block map = (Block)block.getObject(position, Block.class);
        boolean first = true;
        for (int elementIndex = 0; elementIndex < map.getPositionCount(); elementIndex += 2) {
            if (map.isNull(elementIndex)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Map must never contain null keys");
            }
            if (!first) {
                output.writeByte((int)this.elementSeparator);
            }
            first = false;
            this.keyEncoding.encodeValueInto(map, elementIndex, output);
            output.writeByte((int)this.keyValueSeparator);
            if (map.isNull(elementIndex + 1)) {
                output.writeBytes(this.nullSequence);
                continue;
            }
            this.valueEncoding.encodeValueInto(map, elementIndex + 1, output);
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) throws FileCorruptionException {
        KeyOnlyEntryDecoder keyDecoder = new KeyOnlyEntryDecoder();
        this.processEntries(slice, offset, length, keyDecoder);
        Block keyBlock = keyDecoder.getKeyBlock();
        boolean[] distinctKeys = this.distinctMapKeys.selectDistinctKeys(keyBlock);
        ((MapBlockBuilder)builder).buildEntry((keyBuilder, valueBuilder) -> {
            DistinctEntryDecoder entryDecoder = new DistinctEntryDecoder(distinctKeys, keyBlock, keyBuilder, valueBuilder);
            this.processEntries(slice, offset, length, entryDecoder);
        });
    }

    private void processEntries(Slice slice, int offset, int length, EntryDecoder entryDecoder) throws FileCorruptionException {
        int end = offset + length;
        if (length > 0) {
            int elementOffset = offset;
            int keyValueSeparatorPosition = -1;
            while (offset < end) {
                byte currentByte = slice.getByte(offset);
                if (currentByte == this.elementSeparator) {
                    entryDecoder.decodeEntry(slice, elementOffset, offset, keyValueSeparatorPosition);
                    elementOffset = offset + 1;
                    keyValueSeparatorPosition = -1;
                } else if (currentByte == this.keyValueSeparator && keyValueSeparatorPosition == -1) {
                    keyValueSeparatorPosition = offset;
                } else if (this.isEscapeByte(currentByte) && offset + 1 < length) {
                    ++offset;
                }
                ++offset;
            }
            entryDecoder.decodeEntry(slice, elementOffset, offset, keyValueSeparatorPosition);
        }
    }

    private class KeyOnlyEntryDecoder
    implements EntryDecoder {
        private KeyOnlyEntryDecoder() {
        }

        public Block getKeyBlock() {
            Block keyBlock = MapEncoding.this.keyBlockBuilder.build();
            MapEncoding.this.keyBlockBuilder = MapEncoding.this.mapType.getKeyType().createBlockBuilder(null, keyBlock.getPositionCount());
            return keyBlock;
        }

        @Override
        public void decodeKeyValue(int depth, Slice slice, int keyOffset, int keyLength, boolean hasValue, int valueOffset, int valueLength) throws FileCorruptionException {
            if (MapEncoding.this.isNullSequence(slice, keyOffset, keyLength)) {
                MapEncoding.this.keyBlockBuilder.appendNull();
            } else {
                MapEncoding.this.keyEncoding.decodeValueInto(MapEncoding.this.keyBlockBuilder, slice, keyOffset, keyLength);
            }
        }
    }

    private static interface EntryDecoder {
        default public void decodeEntry(Slice slice, int entryOffset, int entryEnd, int keyValueSeparatorPosition) throws FileCorruptionException {
            int valueLength;
            int valueOffset;
            int keyLength;
            boolean hasValue;
            boolean bl = hasValue = keyValueSeparatorPosition >= 0;
            if (hasValue) {
                keyLength = keyValueSeparatorPosition - entryOffset;
                valueOffset = keyValueSeparatorPosition + 1;
                valueLength = entryEnd - valueOffset;
            } else {
                keyLength = entryEnd - entryOffset;
                valueOffset = entryOffset;
                valueLength = 0;
            }
            this.decodeKeyValue(0, slice, entryOffset, keyLength, hasValue, valueOffset, valueLength);
        }

        public void decodeKeyValue(int var1, Slice var2, int var3, int var4, boolean var5, int var6, int var7) throws FileCorruptionException;
    }

    private class DistinctEntryDecoder
    implements EntryDecoder {
        private final boolean[] distinctKeys;
        private final Block keyBlock;
        private final BlockBuilder keyBuilder;
        private final BlockBuilder valueBuilder;
        private int entryPosition;

        public DistinctEntryDecoder(boolean[] distinctKeys, Block keyBlock, BlockBuilder keyBuilder, BlockBuilder valueBuilder) {
            this.distinctKeys = distinctKeys;
            this.keyBlock = keyBlock;
            this.keyBuilder = keyBuilder;
            this.valueBuilder = valueBuilder;
        }

        @Override
        public void decodeKeyValue(int depth, Slice slice, int keyOffset, int keyLength, boolean hasValue, int valueOffset, int valueLength) throws FileCorruptionException {
            if (this.distinctKeys[this.entryPosition]) {
                MapEncoding.this.mapType.getKeyType().appendTo(this.keyBlock, this.entryPosition, this.keyBuilder);
                if (hasValue && !MapEncoding.this.isNullSequence(slice, valueOffset, valueLength)) {
                    MapEncoding.this.valueEncoding.decodeValueInto(this.valueBuilder, slice, valueOffset, valueLength);
                } else {
                    this.valueBuilder.appendNull();
                }
            }
            ++this.entryPosition;
        }
    }
}

