/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.ReadWriteUtils;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncoding;
import io.trino.hive.formats.encodings.binary.BlockEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.type.Type;

public class MapEncoding
extends BlockEncoding {
    private final BinaryColumnEncoding keyReader;
    private final BinaryColumnEncoding valueReader;

    public MapEncoding(Type type, BinaryColumnEncoding keyReader, BinaryColumnEncoding valueReader) {
        super(type);
        this.keyReader = keyReader;
        this.valueReader = valueReader;
    }

    @Override
    public void encodeValue(Block block, int position, SliceOutput output) {
        int elementIndex;
        Block map = (Block)block.getObject(position, Block.class);
        ReadWriteUtils.writeVInt(output, map.getPositionCount() / 2);
        int nullByte = 85;
        int bits = 0;
        for (elementIndex = 0; elementIndex < map.getPositionCount(); elementIndex += 2) {
            if (map.isNull(elementIndex)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Map must never contain null keys");
            }
            if (bits == 8) {
                output.writeByte(nullByte);
                nullByte = 85;
                bits = 0;
            }
            if (!map.isNull(elementIndex + 1)) {
                nullByte |= 1 << bits + 1;
            }
            bits += 2;
        }
        output.writeByte(nullByte);
        for (elementIndex = 0; elementIndex < map.getPositionCount(); elementIndex += 2) {
            if (map.isNull(elementIndex)) continue;
            this.keyReader.encodeValueInto(map, elementIndex, output);
            if (map.isNull(elementIndex + 1)) continue;
            this.valueReader.encodeValueInto(map, elementIndex + 1, output);
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        ((MapBlockBuilder)builder).buildEntry((keyBuilder, valueBuilder) -> this.decodeValueInto(keyBuilder, valueBuilder, slice, offset));
    }

    private void decodeValueInto(BlockBuilder keyBuilder, BlockBuilder valueBuilder, Slice slice, int offset) {
        int nullByteEnd;
        int entries = Math.toIntExact(ReadWriteUtils.readVInt(slice, offset));
        offset += ReadWriteUtils.decodeVIntSize(slice.getByte(offset));
        int nullByteCur = offset;
        int elementOffset = nullByteEnd = offset + (entries * 2 + 7) / 8;
        for (int i = 0; i < entries; ++i) {
            boolean nullKey;
            if ((slice.getByte(nullByteCur) & 1 << i * 2 % 8) != 0) {
                int keyOffset = this.keyReader.getValueOffset(slice, elementOffset);
                int keyLength = this.keyReader.getValueLength(slice, elementOffset);
                this.keyReader.decodeValueInto(keyBuilder, slice, elementOffset + keyOffset, keyLength);
                nullKey = false;
                elementOffset = elementOffset + keyOffset + keyLength;
            } else {
                nullKey = true;
            }
            if ((slice.getByte(nullByteCur) & 1 << (i * 2 + 1) % 8) != 0) {
                int valueOffset = this.valueReader.getValueOffset(slice, elementOffset);
                int valueLength = this.valueReader.getValueLength(slice, elementOffset);
                if (!nullKey) {
                    this.valueReader.decodeValueInto(valueBuilder, slice, elementOffset + valueOffset, valueLength);
                }
                elementOffset = elementOffset + valueOffset + valueLength;
            } else if (!nullKey) {
                valueBuilder.appendNull();
            }
            if (3 != i % 4) continue;
            ++nullByteCur;
        }
    }
}

