/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.List;

public final class UnionToRowCoercionUtils {
    public static final String UNION_FIELD_TAG_NAME = "tag";
    public static final String UNION_FIELD_FIELD_PREFIX = "field";
    public static final Type UNION_FIELD_TAG_TYPE = TinyintType.TINYINT;

    private UnionToRowCoercionUtils() {
    }

    public static RowType rowTypeForUnionOfTypes(List<Type> types) {
        ImmutableList.Builder fields = ImmutableList.builder().add((Object)RowType.field((String)UNION_FIELD_TAG_NAME, (Type)UNION_FIELD_TAG_TYPE));
        for (int i = 0; i < types.size(); ++i) {
            fields.add((Object)RowType.field((String)(UNION_FIELD_FIELD_PREFIX + i), (Type)types.get(i)));
        }
        return RowType.from((List)fields.build());
    }

    public static TypeSignature rowTypeSignatureForUnionOfTypes(List<TypeSignature> typeSignatures) {
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.add((Object)TypeSignatureParameter.namedField((String)UNION_FIELD_TAG_NAME, (TypeSignature)UNION_FIELD_TAG_TYPE.getTypeSignature()));
        for (int i = 0; i < typeSignatures.size(); ++i) {
            fields.add((Object)TypeSignatureParameter.namedField((String)(UNION_FIELD_FIELD_PREFIX + i), (TypeSignature)typeSignatures.get(i)));
        }
        return TypeSignature.rowType((List)fields.build());
    }
}

