/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs.gcs;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.hdfs.ConfigurationInitializer;
import io.trino.hdfs.DynamicConfigurationProvider;
import io.trino.hdfs.gcs.GcsConfigurationProvider;
import io.trino.hdfs.gcs.GcsStorageFactory;
import io.trino.hdfs.gcs.GoogleGcsConfigurationInitializer;
import io.trino.hdfs.gcs.HiveGcsConfig;
import io.trino.hdfs.rubix.RubixEnabledConfig;

public class HiveGcsModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(HiveGcsConfig.class);
        Multibinder.newSetBinder((Binder)binder, ConfigurationInitializer.class).addBinding().to(GoogleGcsConfigurationInitializer.class).in(Scopes.SINGLETON);
        if (((HiveGcsConfig)this.buildConfigObject(HiveGcsConfig.class)).isUseGcsAccessToken()) {
            Preconditions.checkArgument((!((RubixEnabledConfig)this.buildConfigObject(RubixEnabledConfig.class)).isCacheEnabled() ? 1 : 0) != 0, (Object)"Use of GCS access token is not compatible with Hive caching");
            Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class).addBinding().to(GcsConfigurationProvider.class).in(Scopes.SINGLETON);
        }
        binder.bind(GcsStorageFactory.class).in(Scopes.SINGLETON);
    }
}

