/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JVMId;

class JvmContext
implements Writable {
    public static final Logger LOG = LoggerFactory.getLogger(JvmContext.class);
    JVMId jvmId;
    String pid;

    JvmContext() {
        this.jvmId = new JVMId();
        this.pid = "";
    }

    JvmContext(JVMId id, String pid) {
        this.jvmId = id;
        this.pid = pid;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.jvmId.readFields(in);
        this.pid = Text.readString(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.jvmId.write(out);
        Text.writeString(out, this.pid);
    }
}

