/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsLoader;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsViewer;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OfflineEditsBinaryLoader
implements OfflineEditsLoader {
    private final OfflineEditsVisitor visitor;
    private final EditLogInputStream inputStream;
    private final boolean fixTxIds;
    private final boolean recoveryMode;
    private long nextTxId;
    public static final Logger LOG = LoggerFactory.getLogger(OfflineEditsBinaryLoader.class.getName());

    public OfflineEditsBinaryLoader(OfflineEditsVisitor visitor, EditLogInputStream inputStream, OfflineEditsViewer.Flags flags) {
        this.visitor = visitor;
        this.inputStream = inputStream;
        this.fixTxIds = flags.getFixTxIds();
        this.recoveryMode = flags.getRecoveryMode();
        this.nextTxId = -1L;
    }

    @Override
    public void loadEdits() throws IOException {
        try {
            this.visitor.start(this.inputStream.getVersion(true));
            while (true) {
                try {
                    FSEditLogOp op;
                    while ((op = this.inputStream.readOp()) != null) {
                        if (this.fixTxIds) {
                            if (this.nextTxId <= 0L) {
                                this.nextTxId = op.getTransactionId();
                                if (this.nextTxId <= 0L) {
                                    this.nextTxId = 1L;
                                }
                            }
                            op.setTransactionId(this.nextTxId);
                            ++this.nextTxId;
                        }
                        this.visitor.visitOp(op);
                    }
                }
                catch (IOException e) {
                    if (!this.recoveryMode) {
                        LOG.error("Got IOException at position " + this.inputStream.getPosition());
                        this.visitor.close(e);
                        throw e;
                    }
                    LOG.error("Got IOException while reading stream!  Resyncing.", e);
                    this.inputStream.resync();
                    continue;
                }
                catch (RuntimeException e) {
                    if (!this.recoveryMode) {
                        LOG.error("Got RuntimeException at position " + this.inputStream.getPosition());
                        this.visitor.close(e);
                        throw e;
                    }
                    LOG.error("Got RuntimeException while reading stream!  Resyncing.", e);
                    this.inputStream.resync();
                    continue;
                }
                break;
            }
            this.visitor.close(null);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(LOG, this.inputStream);
            throw throwable;
        }
        IOUtils.cleanupWithLogger(LOG, this.inputStream);
    }
}

