/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class GlobalStateIdContext
implements AlignmentContext {
    private static final long ESTIMATED_TRANSACTIONS_PER_SECOND = 10000L;
    private static final float ESTIMATED_SERVER_TIME_MULTIPLIER = 0.8f;
    private final FSNamesystem namesystem;
    private final HashSet<String> coordinatedMethods;

    GlobalStateIdContext(FSNamesystem namesystem) {
        this.namesystem = namesystem;
        this.coordinatedMethods = new HashSet();
        for (Method method : ClientProtocol.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ReadOnly.class) || !((ReadOnly[])method.getAnnotationsByType(ReadOnly.class))[0].isCoordinated()) continue;
            this.coordinatedMethods.add(method.getName());
        }
    }

    @Override
    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
        header.setStateId(this.getLastSeenStateId());
    }

    @Override
    public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
    }

    @Override
    public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
    }

    @Override
    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long clientWaitTime) throws IOException {
        if (!header.hasStateId() && HAServiceProtocol.HAServiceState.OBSERVER.equals((Object)this.namesystem.getState())) {
            throw new StandbyException("Observer Node received request without stateId. This mostly likely is because client is not configured with " + ObserverReadProxyProvider.class.getSimpleName());
        }
        long serverStateId = this.getLastSeenStateId();
        long clientStateId = header.getStateId();
        FSNamesystem.LOG.trace("Client State ID= {} and Server State ID= {}", (Object)clientStateId, (Object)serverStateId);
        if (clientStateId > serverStateId && HAServiceProtocol.HAServiceState.ACTIVE.equals((Object)this.namesystem.getState())) {
            FSNamesystem.LOG.warn("The client stateId: {} is greater than the server stateId: {} This is unexpected. Resetting client stateId to server stateId", (Object)clientStateId, (Object)serverStateId);
            return serverStateId;
        }
        if (HAServiceProtocol.HAServiceState.OBSERVER.equals((Object)this.namesystem.getState()) && (float)(clientStateId - serverStateId) > (float)(10000L * TimeUnit.MILLISECONDS.toSeconds(clientWaitTime)) * 0.8f) {
            throw new RetriableException("Observer Node is too far behind: serverStateId = " + serverStateId + " clientStateId = " + clientStateId);
        }
        return clientStateId;
    }

    @Override
    public long getLastSeenStateId() {
        return this.namesystem.getFSImage().getLastAppliedOrWrittenTxId();
    }

    @Override
    public boolean isCoordinatedCall(String protocolName, String methodName) {
        return protocolName.equals(ClientProtocol.class.getCanonicalName()) && this.coordinatedMethods.contains(methodName);
    }
}

