/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.connectors;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;

class DBNameNodeConnector
implements ClusterConnector {
    private static final Logger LOG = LoggerFactory.getLogger(DBNameNodeConnector.class);
    static final Path DISKBALANCER_ID_PATH = new Path("/system/diskbalancer.id");
    private final URI clusterURI;
    private final NameNodeConnector connector;

    public DBNameNodeConnector(URI clusterURI, Configuration conf) throws IOException, URISyntaxException {
        NameNodeConnector.setWrite2IdFile(false);
        try {
            this.connector = new NameNodeConnector("DiskBalancer", clusterURI, DISKBALANCER_ID_PATH, null, conf, 1);
        }
        catch (IOException ex) {
            LOG.error("Unable to connect to NameNode " + ex.toString());
            throw ex;
        }
        this.clusterURI = clusterURI;
    }

    @Override
    public List<DiskBalancerDataNode> getNodes() throws Exception {
        DatanodeStorageReport[] reports;
        Preconditions.checkNotNull(this.connector);
        LinkedList<DiskBalancerDataNode> nodeList = new LinkedList<DiskBalancerDataNode>();
        for (DatanodeStorageReport report : reports = this.connector.getLiveDatanodeStorageReport()) {
            DiskBalancerDataNode datanode = this.getBalancerNodeFromDataNode(report.getDatanodeInfo());
            this.getVolumeInfoFromStorageReports(datanode, report.getStorageReports());
            nodeList.add(datanode);
        }
        return nodeList;
    }

    @Override
    public String getConnectorInfo() {
        return "Name Node Connector : " + this.clusterURI.toString();
    }

    private DiskBalancerDataNode getBalancerNodeFromDataNode(DatanodeInfo nodeInfo) {
        Preconditions.checkNotNull(nodeInfo);
        DiskBalancerDataNode dbDataNode = new DiskBalancerDataNode(nodeInfo.getDatanodeUuid());
        dbDataNode.setDataNodeIP(nodeInfo.getIpAddr());
        dbDataNode.setDataNodeName(nodeInfo.getHostName());
        dbDataNode.setDataNodePort(nodeInfo.getIpcPort());
        return dbDataNode;
    }

    private void getVolumeInfoFromStorageReports(DiskBalancerDataNode node, StorageReport[] reports) throws Exception {
        Preconditions.checkNotNull(node);
        Preconditions.checkNotNull(reports);
        for (StorageReport report : reports) {
            DatanodeStorage storage = report.getStorage();
            DiskBalancerVolume volume = new DiskBalancerVolume();
            volume.setCapacity(report.getCapacity());
            volume.setFailed(report.isFailed());
            volume.setUsed(report.getDfsUsed());
            volume.setUuid(storage.getStorageID());
            volume.setSkip(storage.getState() == DatanodeStorage.State.READ_ONLY_SHARED || report.isFailed());
            volume.setStorageType(storage.getStorageType().name());
            volume.setIsTransient(storage.getStorageType().isTransient());
            node.addVolume(volume);
        }
    }
}

