/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreBuilder;
import org.apache.hadoop.metrics2.MetricStringBuilder;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableMetric;

public class AbfsCountersImpl
implements AbfsCounters {
    private static final String CONTEXT = "AbfsContext";
    private static final String REGISTRY_ID = "AbfsID";
    private static final String METRIC_BUCKET = "AbfsBucket";
    private final MetricsRegistry registry = new MetricsRegistry("abfsMetrics").setContext("AbfsContext");
    private final IOStatisticsStore ioStatisticsStore;
    private static final AbfsStatistic[] STATISTIC_LIST = new AbfsStatistic[]{AbfsStatistic.CALL_CREATE, AbfsStatistic.CALL_OPEN, AbfsStatistic.CALL_GET_FILE_STATUS, AbfsStatistic.CALL_APPEND, AbfsStatistic.CALL_CREATE_NON_RECURSIVE, AbfsStatistic.CALL_DELETE, AbfsStatistic.CALL_EXIST, AbfsStatistic.CALL_GET_DELEGATION_TOKEN, AbfsStatistic.CALL_LIST_STATUS, AbfsStatistic.CALL_MKDIRS, AbfsStatistic.CALL_RENAME, AbfsStatistic.DIRECTORIES_CREATED, AbfsStatistic.DIRECTORIES_DELETED, AbfsStatistic.FILES_CREATED, AbfsStatistic.FILES_DELETED, AbfsStatistic.ERROR_IGNORED, AbfsStatistic.CONNECTIONS_MADE, AbfsStatistic.SEND_REQUESTS, AbfsStatistic.GET_RESPONSES, AbfsStatistic.BYTES_SENT, AbfsStatistic.BYTES_RECEIVED, AbfsStatistic.READ_THROTTLES, AbfsStatistic.WRITE_THROTTLES, AbfsStatistic.SERVER_UNAVAILABLE, AbfsStatistic.RENAME_RECOVERY, AbfsStatistic.METADATA_INCOMPLETE_RENAME_FAILURES, AbfsStatistic.RENAME_PATH_ATTEMPTS};
    private static final AbfsStatistic[] DURATION_TRACKER_LIST = new AbfsStatistic[]{AbfsStatistic.HTTP_HEAD_REQUEST, AbfsStatistic.HTTP_GET_REQUEST, AbfsStatistic.HTTP_DELETE_REQUEST, AbfsStatistic.HTTP_PUT_REQUEST, AbfsStatistic.HTTP_PATCH_REQUEST, AbfsStatistic.HTTP_POST_REQUEST};

    public AbfsCountersImpl(URI uri) {
        UUID fileSystemInstanceId = UUID.randomUUID();
        this.registry.tag(REGISTRY_ID, "A unique identifier for the instance", fileSystemInstanceId.toString());
        this.registry.tag(METRIC_BUCKET, "Hostname from the FS URL", uri.getHost());
        IOStatisticsStoreBuilder ioStatisticsStoreBuilder = IOStatisticsBinding.iostatisticsStore();
        for (AbfsStatistic stats : STATISTIC_LIST) {
            ioStatisticsStoreBuilder.withCounters(stats.getStatName());
            this.createCounter(stats);
        }
        for (AbfsStatistic durationStats : DURATION_TRACKER_LIST) {
            ioStatisticsStoreBuilder.withDurationTracking(durationStats.getStatName());
        }
        this.ioStatisticsStore = ioStatisticsStoreBuilder.build();
    }

    private MutableMetric lookupMetric(String name) {
        return this.getRegistry().get(name);
    }

    private MutableCounterLong lookupCounter(String name) {
        MutableMetric metric = this.lookupMetric(name);
        if (metric == null) {
            return null;
        }
        if (!(metric instanceof MutableCounterLong)) {
            throw new IllegalStateException("Metric " + name + " is not a MutableCounterLong: " + metric);
        }
        return (MutableCounterLong)metric;
    }

    private MutableCounterLong createCounter(AbfsStatistic stats) {
        return this.registry.newCounter(stats.getStatName(), stats.getStatDescription(), 0L);
    }

    @Override
    public void incrementCounter(AbfsStatistic statistic, long value) {
        this.ioStatisticsStore.incrementCounter(statistic.getStatName(), value);
        MutableCounterLong counter = this.lookupCounter(statistic.getStatName());
        if (counter != null) {
            counter.incr(value);
        }
    }

    private MetricsRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public String formString(String prefix, String separator, String suffix, boolean all) {
        MetricStringBuilder metricStringBuilder = new MetricStringBuilder(null, prefix, separator, suffix);
        this.registry.snapshot(metricStringBuilder, all);
        return metricStringBuilder.toString();
    }

    @Override
    @VisibleForTesting
    public Map<String, Long> toMap() {
        return this.ioStatisticsStore.counters();
    }

    @Override
    public IOStatistics getIOStatistics() {
        return this.ioStatisticsStore;
    }

    @Override
    public DurationTracker trackDuration(String key) {
        return this.ioStatisticsStore.trackDuration(key);
    }
}

