/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemCache;
import org.apache.hadoop.fs.ForwardingFileSystemCache;

public final class FileSystemManager {
    private static FileSystemCache existingCache = null;

    private FileSystemManager() {
    }

    public static synchronized void registerCache(FileSystemCache cache) {
        Objects.requireNonNull(cache, "cache is null");
        if (existingCache == null) {
            FileSystem.CACHE = new ForwardingFileSystemCache(cache);
            existingCache = cache;
        } else if (existingCache != cache) {
            throw new IllegalStateException("FileSystem cache already registered");
        }
    }
}

