/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.pkinit;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CertificateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateHelper.class);

    public static List<Certificate> loadCerts(String filename) throws KrbException {
        File file = new File(filename);
        InputStream res = null;
        if (file.isFile()) {
            try {
                res = Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Can't load cert, file not found. " + e);
            }
        } else {
            res = CertificateHelper.class.getClassLoader().getResourceAsStream(filename);
        }
        return CertificateHelper.loadCerts(res);
    }

    public static List<Certificate> loadCerts(InputStream inputStream) throws KrbException {
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = certFactory.generateCertificates(inputStream);
            return new ArrayList<Certificate>(certs);
        }
        catch (CertificateException e) {
            throw new KrbException("Failed to load certificates", (Throwable)e);
        }
    }
}

