/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.keytab;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbOutputStream;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class KeytabOutputStream
extends KrbOutputStream {
    public KeytabOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writePrincipal(PrincipalName principal, int version) throws IOException {
        List<String> nameStrings = principal.getNameStrings();
        int numComponents = principal.getNameStrings().size();
        String realm = principal.getRealm();
        this.writeShort(numComponents);
        this.writeCountedString(realm);
        for (String nameCom : nameStrings) {
            this.writeCountedString(nameCom);
        }
        this.writeInt(principal.getNameType().getValue());
    }

    @Override
    public void writeKey(EncryptionKey key, int version) throws IOException {
        this.writeShort(key.getKeyType().getValue());
        this.writeCountedOctets(key.getKeyData());
    }

    @Override
    public void writeCountedOctets(byte[] data) throws IOException {
        this.writeShort(data.length);
        this.write(data);
    }
}

