/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public abstract class KrbOutputStream
extends DataOutputStream {
    public KrbOutputStream(OutputStream out) {
        super(out);
    }

    public abstract void writePrincipal(PrincipalName var1, int var2) throws IOException;

    public void writeRealm(String realm) throws IOException {
        this.writeCountedString(realm);
    }

    public abstract void writeKey(EncryptionKey var1, int var2) throws IOException;

    public void writeTime(KerberosTime ktime) throws IOException {
        int time = 0;
        if (ktime != null) {
            time = (int)(((Date)ktime.getValue()).getTime() / 1000L);
        }
        this.writeInt(time);
    }

    public void writeCountedString(String string) throws IOException {
        byte[] data = string != null ? string.getBytes(StandardCharsets.UTF_8) : null;
        this.writeCountedOctets(data);
    }

    public void writeCountedOctets(byte[] data) throws IOException {
        if (data != null) {
            this.writeInt(data.length);
            this.write(data);
        } else {
            this.writeInt(0);
        }
    }
}

