/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.commons.configuration2.tree;

import io.trino.hadoop.$internal.org.apache.commons.configuration2.tree.ImmutableNode;
import io.trino.hadoop.$internal.org.apache.commons.configuration2.tree.NodeCombiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MergeCombiner
extends NodeCombiner {
    @Override
    public ImmutableNode combine(ImmutableNode node1, ImmutableNode node2) {
        ImmutableNode.Builder result = new ImmutableNode.Builder();
        result.name(node1.getNodeName());
        result.value(node1.getValue());
        this.addAttributes(result, node1, node2);
        LinkedList<ImmutableNode> children2 = new LinkedList<ImmutableNode>(node2.getChildren());
        for (ImmutableNode child1 : node1) {
            ImmutableNode child2 = this.canCombine(node2, child1, children2);
            if (child2 != null) {
                result.addChild(this.combine(child1, child2));
                children2.remove(child2);
                continue;
            }
            result.addChild(child1);
        }
        for (ImmutableNode c : children2) {
            result.addChild(c);
        }
        return result.create();
    }

    protected void addAttributes(ImmutableNode.Builder result, ImmutableNode node1, ImmutableNode node2) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(node1.getAttributes());
        for (Map.Entry<String, Object> e : node2.getAttributes().entrySet()) {
            if (attributes.containsKey(e.getKey())) continue;
            attributes.put(e.getKey(), e.getValue());
        }
        result.addAttributes(attributes);
    }

    protected ImmutableNode canCombine(ImmutableNode node2, ImmutableNode child, List<ImmutableNode> children2) {
        Map<String, Object> attrs1 = child.getAttributes();
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>();
        List<ImmutableNode> children = HANDLER.getChildren(node2, child.getNodeName());
        for (ImmutableNode node : children) {
            if (!MergeCombiner.matchAttributes(attrs1, node)) continue;
            nodes.add(node);
        }
        if (nodes.size() == 1) {
            return (ImmutableNode)nodes.get(0);
        }
        if (nodes.size() > 1 && !this.isListNode(child)) {
            for (ImmutableNode node : nodes) {
                children2.remove(node);
            }
        }
        return null;
    }

    private static boolean matchAttributes(Map<String, Object> attrs1, ImmutableNode node) {
        Map<String, Object> attrs2 = node.getAttributes();
        for (Map.Entry<String, Object> e : attrs1.entrySet()) {
            if (!attrs2.containsKey(e.getKey()) || Objects.equals(e.getValue(), attrs2.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }
}

