/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.blob;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.AccessCondition;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageErrorCode;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.blob.BlobRequestOptions;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlob;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Base64;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class BlobInputStream
extends InputStream {
    private final CloudBlob parentBlobRef;
    private MessageDigest md5Digest;
    private volatile boolean streamFaulted;
    private IOException lastError;
    private final OperationContext opContext;
    private final BlobRequestOptions options;
    private long streamLength = -1L;
    private final int readSize;
    private boolean validateBlobMd5;
    private final String retrievedContentMD5Value;
    private ByteArrayInputStream currentBuffer;
    private long markedPosition;
    private int markExpiry;
    private long currentAbsoluteReadPosition;
    private long bufferStartOffset;
    private int bufferSize;
    private AccessCondition accessCondition = null;

    @.DoesServiceRequest
    protected BlobInputStream(CloudBlob parentBlob, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.parentBlobRef = parentBlob;
        this.parentBlobRef.assertCorrectBlobType();
        this.options = new BlobRequestOptions(options);
        this.opContext = opContext;
        this.streamFaulted = false;
        this.currentAbsoluteReadPosition = 0L;
        this.readSize = parentBlob.getStreamMinimumReadSizeInBytes();
        if (options.getUseTransactionalContentMD5().booleanValue() && this.readSize > 0x400000) {
            throw new IllegalArgumentException("Cannot specify x-ms-range-get-content-md5 header on ranges larger than 4 MB. Either use a BlobReadStream via openRead, or disable TransactionalMD5 via the BlobRequestOptions.");
        }
        parentBlob.downloadAttributes(accessCondition, this.options, this.opContext);
        this.retrievedContentMD5Value = parentBlob.getProperties().getContentMD5();
        this.validateBlobMd5 = options.getDisableContentMD5Validation() == false && !Utility.isNullOrEmpty(this.retrievedContentMD5Value);
        String previousLeaseId = null;
        if (accessCondition != null) {
            previousLeaseId = accessCondition.getLeaseID();
            if (!accessCondition.verifyConditional(this.parentBlobRef.getProperties().getEtag(), this.parentBlobRef.getProperties().getLastModified())) {
                throw new StorageException(StorageErrorCode.CONDITION_FAILED.toString(), "The conditionals specified for this operation did not match server.", 412, null, null);
            }
        }
        this.accessCondition = AccessCondition.generateIfMatchCondition(this.parentBlobRef.getProperties().getEtag());
        this.accessCondition.setLeaseID(previousLeaseId);
        this.streamLength = parentBlob.getProperties().getLength();
        if (this.validateBlobMd5) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        this.reposition(0L);
    }

    @Override
    public synchronized int available() throws IOException {
        return this.bufferSize - (int)(this.currentAbsoluteReadPosition - this.bufferStartOffset);
    }

    private synchronized void checkStreamState() throws IOException {
        if (this.streamFaulted) {
            throw this.lastError;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.currentBuffer = null;
        this.streamFaulted = true;
        this.lastError = new IOException("Stream is already closed.");
    }

    @.DoesServiceRequest
    private synchronized void dispatchRead(int readLength) throws IOException {
        try {
            byte[] byteBuffer = new byte[readLength];
            this.parentBlobRef.downloadRangeInternal(this.currentAbsoluteReadPosition, Long.valueOf(readLength), byteBuffer, 0, this.accessCondition, this.options, this.opContext);
            this.currentBuffer = new ByteArrayInputStream(byteBuffer);
            this.bufferSize = readLength;
            this.bufferStartOffset = this.currentAbsoluteReadPosition;
        }
        catch (StorageException e) {
            this.streamFaulted = true;
            this.lastError = Utility.initIOException(e);
            throw this.lastError;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markedPosition = this.currentAbsoluteReadPosition;
        this.markExpiry = readlimit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    @.DoesServiceRequest
    public int read() throws IOException {
        byte[] tBuff = new byte[1];
        int numberOfBytesRead = this.read(tBuff, 0, 1);
        if (numberOfBytesRead > 0) {
            return tBuff[0] & 0xFF;
        }
        if (numberOfBytesRead == 0) {
            throw new IOException("Unexpected error. Stream returned unexpected number of bytes.");
        }
        return -1;
    }

    @Override
    @.DoesServiceRequest
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    @.DoesServiceRequest
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        return this.readInternal(b, off, len);
    }

    @.DoesServiceRequest
    private synchronized int readInternal(byte[] b, int off, int len) throws IOException {
        int numberOfBytesRead;
        this.checkStreamState();
        if ((this.currentBuffer == null || this.currentBuffer.available() == 0) && this.currentAbsoluteReadPosition < this.streamLength) {
            this.dispatchRead((int)Math.min((long)this.readSize, this.streamLength - this.currentAbsoluteReadPosition));
        }
        if ((numberOfBytesRead = this.currentBuffer.read(b, off, len = Math.min(len, this.readSize))) > 0) {
            this.currentAbsoluteReadPosition += (long)numberOfBytesRead;
            if (this.validateBlobMd5) {
                String calculatedMd5;
                this.md5Digest.update(b, off, numberOfBytesRead);
                if (this.currentAbsoluteReadPosition == this.streamLength && !(calculatedMd5 = Base64.encode(this.md5Digest.digest())).equals(this.retrievedContentMD5Value)) {
                    this.lastError = Utility.initIOException(new StorageException("InvalidMd5", String.format("Blob data corrupted (integrity check failed), Expected value is %s, retrieved %s", this.retrievedContentMD5Value, calculatedMd5), 306, null, null));
                    this.streamFaulted = true;
                    throw this.lastError;
                }
            }
        }
        if (this.markExpiry > 0 && this.markedPosition + (long)this.markExpiry < this.currentAbsoluteReadPosition) {
            this.markedPosition = 0L;
            this.markExpiry = 0;
        }
        return numberOfBytesRead;
    }

    private synchronized void reposition(long absolutePosition) {
        this.currentAbsoluteReadPosition = absolutePosition;
        this.currentBuffer = new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markedPosition + (long)this.markExpiry < this.currentAbsoluteReadPosition) {
            throw new IOException("Stream mark expired.");
        }
        this.validateBlobMd5 = false;
        this.md5Digest = null;
        this.reposition(this.markedPosition);
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (n < 0L || this.currentAbsoluteReadPosition + n > this.streamLength) {
            throw new IndexOutOfBoundsException();
        }
        this.validateBlobMd5 = false;
        this.md5Digest = null;
        this.reposition(this.currentAbsoluteReadPosition + n);
        return n;
    }
}

