/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage;

import java.util.EnumSet;

public enum SharedAccessAccountService {
    BLOB('b'),
    FILE('f'),
    QUEUE('q'),
    TABLE('t');

    char value;

    private SharedAccessAccountService(char c) {
        this.value = c;
    }

    static String servicesToString(EnumSet<SharedAccessAccountService> services) {
        if (services == null) {
            return "";
        }
        StringBuilder value = new StringBuilder();
        for (SharedAccessAccountService service : services) {
            value.append(service.value);
        }
        return value.toString();
    }

    static EnumSet<SharedAccessAccountService> servicesFromString(String servicesString) {
        EnumSet<SharedAccessAccountService> resources = EnumSet.noneOf(SharedAccessAccountService.class);
        for (char c : servicesString.toLowerCase().toCharArray()) {
            boolean invalidCharacter = true;
            for (SharedAccessAccountService service : SharedAccessAccountService.values()) {
                if (c != service.value) continue;
                resources.add(service);
                invalidCharacter = false;
                break;
            }
            if (!invalidCharacter) continue;
            throw new IllegalArgumentException(String.format("%s could not be parsed from '%s'.", "Services", servicesString));
        }
        return resources;
    }
}

