/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.google.re2j;

import io.trino.hadoop.$internal.com.google.re2j.Inst;
import java.util.ArrayList;
import java.util.List;

class Prog {
    private final List<Inst> inst = new ArrayList<Inst>();
    int start;
    int numCap = 2;

    Prog() {
    }

    Inst getInst(int pc) {
        return this.inst.get(pc);
    }

    int numInst() {
        return this.inst.size();
    }

    void addInst(Inst.Op op) {
        this.inst.add(new Inst(op));
    }

    Inst skipNop(int pc) {
        Inst i = this.inst.get(pc);
        while (i.op == Inst.Op.NOP || i.op == Inst.Op.CAPTURE) {
            i = this.inst.get(pc);
            pc = i.out;
        }
        return i;
    }

    boolean prefix(StringBuilder prefix) {
        Inst i = this.skipNop(this.start);
        if (i.op() != Inst.Op.RUNE || i.runes.length != 1) {
            return i.op == Inst.Op.MATCH;
        }
        while (i.op() == Inst.Op.RUNE && i.runes.length == 1 && (i.arg & 1) == 0) {
            prefix.appendCodePoint(i.runes[0]);
            i = this.skipNop(i.out);
        }
        return i.op == Inst.Op.MATCH;
    }

    int startCond() {
        int flag = 0;
        int pc = this.start;
        block5: while (true) {
            Inst i = this.inst.get(pc);
            switch (i.op) {
                case EMPTY_WIDTH: {
                    flag |= i.arg;
                    break;
                }
                case FAIL: {
                    return -1;
                }
                case CAPTURE: 
                case NOP: {
                    break;
                }
                default: {
                    break block5;
                }
            }
            pc = i.out;
        }
        return flag;
    }

    int next(int l) {
        Inst i = this.inst.get(l >> 1);
        if ((l & 1) == 0) {
            return i.out;
        }
        return i.arg;
    }

    void patch(int l, int val) {
        while (l != 0) {
            Inst i = this.inst.get(l >> 1);
            if ((l & 1) == 0) {
                l = i.out;
                i.out = val;
                continue;
            }
            l = i.arg;
            i.arg = val;
        }
    }

    int append(int l1, int l2) {
        int next;
        if (l1 == 0) {
            return l2;
        }
        if (l2 == 0) {
            return l1;
        }
        int last = l1;
        while ((next = this.next(last)) != 0) {
            last = next;
        }
        Inst i = this.inst.get(last >> 1);
        if ((last & 1) == 0) {
            i.out = l2;
        } else {
            i.arg = l2;
        }
        return l1;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int pc = 0; pc < this.inst.size(); ++pc) {
            int len = out.length();
            out.append(pc);
            if (pc == this.start) {
                out.append('*');
            }
            out.append("        ".substring(out.length() - len)).append(this.inst.get(pc)).append('\n');
        }
        return out.toString();
    }
}

