/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.exchange.filesystem.s3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.stats.DistributionStat;
import io.trino.plugin.exchange.filesystem.ExecutionStats;
import io.trino.plugin.exchange.filesystem.s3.S3AsyncClientWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class S3FileSystemExchangeStorageStats {
    private final ExecutionStats createEmptyFile = new ExecutionStats();
    private final ExecutionStats listFilesRecursively = new ExecutionStats();
    private final ExecutionStats deleteRecursively = new ExecutionStats();
    private final ExecutionStats deleteObjects = new ExecutionStats();
    private final DistributionStat deleteObjectsEntriesCount = new DistributionStat();
    private final ExecutionStats getObject = new ExecutionStats();
    private final DistributionStat getObjectDataSizeInBytes = new DistributionStat();
    private final ExecutionStats putObject = new ExecutionStats();
    private final DistributionStat putObjectDataSizeInBytes = new DistributionStat();
    private final ExecutionStats createMultipartUpload = new ExecutionStats();
    private final ExecutionStats uploadPart = new ExecutionStats();
    private final DistributionStat uploadPartDataSizeInBytes = new DistributionStat();
    private final ExecutionStats completeMultipartUpload = new ExecutionStats();
    private final DistributionStat completeMultipartUploadPartsCount = new DistributionStat();
    private final ExecutionStats abortMultipartUpload = new ExecutionStats();
    private final Map<S3AsyncClientWrapper.RequestType, AtomicLong> activeRequests = new ConcurrentHashMap<S3AsyncClientWrapper.RequestType, AtomicLong>();

    @Managed
    @Nested
    public ExecutionStats getCreateEmptyFile() {
        return this.createEmptyFile;
    }

    @Managed
    @Nested
    public ExecutionStats getListFilesRecursively() {
        return this.listFilesRecursively;
    }

    @Managed
    @Nested
    public ExecutionStats getDeleteRecursively() {
        return this.deleteRecursively;
    }

    @Managed
    @Nested
    public ExecutionStats getDeleteObjects() {
        return this.deleteObjects;
    }

    @Managed
    @Nested
    public DistributionStat getDeleteObjectsEntriesCount() {
        return this.deleteObjectsEntriesCount;
    }

    @Managed
    @Nested
    public ExecutionStats getGetObject() {
        return this.getObject;
    }

    @Managed
    @Nested
    public DistributionStat getGetObjectDataSizeInBytes() {
        return this.getObjectDataSizeInBytes;
    }

    @Managed
    @Nested
    public ExecutionStats getPutObject() {
        return this.putObject;
    }

    @Managed
    @Nested
    public DistributionStat getPutObjectDataSizeInBytes() {
        return this.putObjectDataSizeInBytes;
    }

    @Managed
    @Nested
    public ExecutionStats getCreateMultipartUpload() {
        return this.createMultipartUpload;
    }

    @Managed
    @Nested
    public ExecutionStats getUploadPart() {
        return this.uploadPart;
    }

    @Managed
    @Nested
    public DistributionStat getUploadPartDataSizeInBytes() {
        return this.uploadPartDataSizeInBytes;
    }

    @Managed
    @Nested
    public ExecutionStats getCompleteMultipartUpload() {
        return this.completeMultipartUpload;
    }

    @Managed
    @Nested
    public DistributionStat getCompleteMultipartUploadPartsCount() {
        return this.completeMultipartUploadPartsCount;
    }

    @Managed
    @Nested
    public ExecutionStats getAbortMultipartUpload() {
        return this.abortMultipartUpload;
    }

    public void requestStarted(S3AsyncClientWrapper.RequestType requestType) {
        this.activeRequests.computeIfAbsent(requestType, key -> new AtomicLong()).incrementAndGet();
    }

    public void requestCompleted(S3AsyncClientWrapper.RequestType requestType) {
        AtomicLong count = this.activeRequests.get((Object)requestType);
        Preconditions.checkArgument((count != null && count.get() >= 0L ? 1 : 0) != 0, (String)"no active requests of type %s found", (Object)((Object)requestType));
        count.decrementAndGet();
    }

    @Managed
    public long getActivePutObjectRequestCount() {
        return this.getActiveRequestCount(S3AsyncClientWrapper.RequestType.PUT_OBJECT);
    }

    @Managed
    public long getActiveDeleteObjectsRequestCount() {
        return this.getActiveRequestCount(S3AsyncClientWrapper.RequestType.DELETE_OBJECTS);
    }

    @Managed
    public long getActiveGetObjectRequestCount() {
        return this.getActiveRequestCount(S3AsyncClientWrapper.RequestType.GET_OBJECT);
    }

    @Managed
    public long getActiveCreateMultipartUploadRequestCount() {
        return this.getActiveRequestCount(S3AsyncClientWrapper.RequestType.CREATE_MULTIPART_UPLOAD);
    }

    @Managed
    public long getActiveUploadPartRequestCount() {
        return this.getActiveRequestCount(S3AsyncClientWrapper.RequestType.UPLOAD_PART);
    }

    @Managed
    public long getActiveCompleteMultipartUploadRequestCount() {
        return this.getActiveRequestCount(S3AsyncClientWrapper.RequestType.COMPLETE_MULTIPART_UPLOAD);
    }

    @Managed
    public long getActiveAbortMultipartUploadRequestCount() {
        return this.getActiveRequestCount(S3AsyncClientWrapper.RequestType.ABORT_MULTIPART_UPLOAD);
    }

    @Managed
    public long getListObjectsV2RequestCount() {
        return this.getActiveRequestCount(S3AsyncClientWrapper.RequestType.LIST_OBJECTS_V2);
    }

    public Map<S3AsyncClientWrapper.RequestType, Long> getActiveRequestsSummary() {
        return (Map)this.activeRequests.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((AtomicLong)entry.getValue()).get()));
    }

    private long getActiveRequestCount(S3AsyncClientWrapper.RequestType requestType) {
        AtomicLong count = this.activeRequests.get((Object)requestType);
        return count == null ? 0L : count.get();
    }
}

