/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.TaskTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;

public class RequestHandlerRegistry<Request extends TransportRequest> {
    private final String action;
    private final TransportRequestHandler<Request> handler;
    private final boolean forceExecution;
    private final boolean canTripCircuitBreaker;
    private final String executor;
    private final TaskManager taskManager;
    private final Writeable.Reader<Request> requestReader;

    public RequestHandlerRegistry(String action, Writeable.Reader<Request> requestReader, TaskManager taskManager, TransportRequestHandler<Request> handler, String executor, boolean forceExecution, boolean canTripCircuitBreaker) {
        this.action = action;
        this.requestReader = requestReader;
        this.handler = handler;
        this.forceExecution = forceExecution;
        this.canTripCircuitBreaker = canTripCircuitBreaker;
        this.executor = executor;
        this.taskManager = taskManager;
    }

    public String getAction() {
        return this.action;
    }

    public Request newRequest(StreamInput in) throws IOException {
        return (Request)((TransportRequest)this.requestReader.read(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageReceived(Request request, TransportChannel channel) throws Exception {
        Task task = this.taskManager.register(channel.getChannelType(), this.action, (TaskAwareRequest)request);
        if (task == null) {
            this.handler.messageReceived(request, channel);
        } else {
            boolean success = false;
            try {
                this.handler.messageReceived(request, new TaskTransportChannel(this.taskManager, task, channel), task);
                success = true;
            }
            finally {
                if (!success) {
                    this.taskManager.unregister(task);
                }
            }
        }
    }

    public boolean isForceExecution() {
        return this.forceExecution;
    }

    public boolean canTripCircuitBreaker() {
        return this.canTripCircuitBreaker;
    }

    public String getExecutor() {
        return this.executor;
    }

    public String toString() {
        return this.handler.toString();
    }
}

